#
#  時刻校正ライブラリspecファイル
#  2014/2/25 prepセクションの/bin/rm, /bin/mkdirコマンド(4行)をinstallセクションの
#            先頭に移動させた。(CentOS64bit環境で動作しなかったため)
#

# 初期設定
%define PKGVER 3.5.0

%define __check_files %{nil}

# ヘッダー部
name: libsctimecal
Version: %{PKGVER}
Release: 0
License: ISAS
#Copyright: ISAS
# 2011.04.20 UPDATE
Group: Development/Libraries
Source: libsctimecal-%{PKGVER}.tar.gz
# 2012.02.23 UPDATE
Summary: SCTIME_CAL LIBRARY
Packager: Fujitsu
Distribution: CentOS
BuildRoot: %{_builddir}/%{name}-root
# 2015.03.17 UPDATE
Requires: /sbin/ldconfig

%description
libsctimecal-%{PKGVER}

%prep

%setup

%build

%define _prefix /usr/local

%ifarch x86_64 ia64
%define _libdir %{_exec_prefix}/lib64
%else
%define _libdir %{_exec_prefix}/lib
%endif

./configure \
  --prefix=%{_prefix} \
  --libdir=%{_libdir} \
  --includedir=%{_includedir}
make

%install
rm -rf ${RPM_BUILD_ROOT}
make install DESTDIR=${RPM_BUILD_ROOT}

mkdir -p ${RPM_BUILD_ROOT}/etc/ld.so.conf.d
echo "%{_libdir}" > ${RPM_BUILD_ROOT}/etc/ld.so.conf.d/%{name}-%{_arch}.conf

%check
make check

%clean
rm -rf ${RPM_BUILD_ROOT}

%pre

%post
/sbin/ldconfig

%postun
if [ $1 = 0 ] ; then
    /sbin/ldconfig
fi

%files

%{_includedir}/*.h
%{_libdir}/libsctimecal*
%{_libdir}/libtimset*
/etc/ld.so.conf.d/*

%changelog
* Mon Jul 31 2023 Fujitsu Limited
- Ver:3.5.0 AlmaLinux9.2対応
* Thu Jan 23 2020 Fujitsu Limited
- Ver:3.3.1 文字コードをUTF-8に統一(コメントの文字化けを修正)
* Sat Feb 23 2019 Fujitsu Limited
- Ver:3.3.0 フレーム方式対応
-           フレーム方式に対応する下記のライブラリ関数を追加
-           tc2es 
-           es2etc
-           es2cetc
-           etc2es
-           recover_missing_bits
* Tue Feb 28 2017 Fujitsu Limited
- Ver:3.1.3 不具合対応
-           RPMファイルの作成で動作確認試験が異常となりRPMパッケージファイルが
-           作成できない不具合の修正
* Tue Dec 22 2015 Fujitsu Limited
- Ver:3.1.2 不具合対応
-           ti2es関数で過去側の解が存在する場合に未来側により近い解があるにもか
-           かわらず未来側を検索しない処理となっていた不具合の修正
-           ti2es関数で連続区間でのロールオーバー検出時に返すETI拡張部をインク
-           リメント/デクリメントしていなかった不具合の修正
-           eti2es関数で連続区間でのロールオーバー検出時に連続区間にもかかわら
-           ず過去側のレコードのレートを使用していたが未来側を使い内挿するよう
-           に修正
* Fri Oct 23 2015 Fujitsu Limited
- Ver:3.1.1 不具合対応
-           ti2es関数で未来側の範囲外に最も近い解があり且つ、過去側の範囲内に
-           解がある場合に、過去側の解が採用されずに異常復帰していた問題に対応
-           レコードの追加読み込み不具合への対処として衛星時刻校正表データ抽出
-           領域を32秒間隔のデータが100日分保持できるように修正
-           処理の高速化を目的として最初の時刻変換関数呼び出し時に衛星時刻校正
-           表の上記領域を一括でメモリ領域に展開し、以降、一定間隔で衛星時刻校
-           正表の更新を確認し更新時に再読み込みを行うように修正
* Tue Mar 17 2015 ISAS/JAXA
- Ver:3.1.0 Shared library対応
-           libtoolを使用してshared libraryに対応
-           rpm package用のspec fileを変更
* Fri Mar 13 2015 Fujitsu Limited
- Ver:3.1.0 2014年度改修
-           衛星時刻校正表フォーマット変更に伴い最低レコード長を204バイトに変更
-           utc2es関数でパラメータutcのパラメータチェック追加
-           ti2es関数でパラメータestimated_utcパラメータチェック追加
-           ti2es関数で検索範囲が指定された場合に洩れる区間がある問題に対応
-           内部関数outputMessageでNULLポインタアクセス問題に対応
-           C++からの呼び出しに対応
-           (Com_type.h、TimeCal_type.h、TiTm_type.h)
* Tue Dec 09 2014 Fujitsu Limited
- Ver:3.0.3 不具合対応
-           es2utc関数で経過秒の小数第7位の四捨五入修正                      
* Mon Sep 01 2014 Fujitsu Limited
- Ver:3.0.2 不具合対応
-           ti2es関数で連続区間の校正まで処理継続するように修正
-           下記関数の変数初期化
-           (es2utcbcd、utcbcd2es、UtTt_Init、TiTm_Init_Sat)
* Fri Oct 04 2013 Fujitsu Limited
- Ver:3.0.0 衛星時刻校正表のレコード長指定対応
-           ti2es関数、eti2es関数の校正時の使用レート選定方法変更
-           eti2es関数、es2eti関数の計算精度問題対応
-           メッセージファイル設定関数(setErrorMsgFile)追加
* Wed Jun 12 2013 Fujitsu Limited
- Ver:2.1.0 後方互換関数追加
* Mon Mar 18 2013 Fujitsu Limited
- Ver:2.0.0 2012年度改修
-           時刻テレメトリTIが2つのフィールドで構成される衛星への対応
-           衛星時刻校正表（旧称：基準時刻ファイル）のフォーマット変更
-           衛星固有設定ファイルのフォーマット変更
-           関数名を全て変更
-           es2ceti関数追加
-           関数の戻り値詳細化
* Thu Feb 23 2012 Fujitsu Limited
- Ver:1.1.0 2011年度改修
-         　うるう秒の表記方法を変更
-         　基準時刻ファイルにコメント行が追加されたことに伴う改修
