/**********************************
 *
 *      Time2Ti CHECK TEST MAIN
 *
 *      testWTIME2TI totalsec(double)
 *
 **********************************/
#include        <stdio.h>
#include        <stdlib.h>
#include        <string.h>
#include        "TiTm_type.h"

int    dtmedt( char *wk );

int    main( argc, argv )
int     argc;
char    *argv[];
{

        char   		wk[30], *fname1, *fname2;

	int 		rtn;
	uint16_t 	ETI;
	uint32_t 	IntTI;
	double 		In_sec;

	/*--------------------------------------------------------------*/
	/* 入力パラメータの解析						*/
	/*--------------------------------------------------------------*/
	if( argc != 2 ) {
		printf( "Usage : testWTIME2TI totalsec(double)\n" );
		exit(1);
	}


      if( fname1 = getenv( "TM_LEAP_FPATH" ) );
      else {
              printf( "environment error :TM_LEAP_FPATH\n" );
              exit(1);
      }


      if( fname2 = getenv( "TM_STD_FPATH" ) );
      else {
              printf( "environment error :TM_STD_FPATH\n" );
              exit(1);
      }


        In_sec = atof( argv[1] );

        /*--------------------------------------------------------------*/
        /* 時刻に変換　　　　                                           */
        /*--------------------------------------------------------------*/
        /****************************************************************/
		memset( wk, 0x00, sizeof(wk) );
        rtn = TT2ASCUT( 1, In_sec, wk );
        /****************************************************************/
        if( rtn < 0 ) {
                printf( "TT2ASCUT error [%d]\n", rtn );
                exit(1);
	}
	/*--------------------------------------------------------------*/
	/* Time2Ti() を実行					*/
	/*--------------------------------------------------------------*/
	printf( "##### Time2Ti #####\n");
	dtmedt( wk );
	printf( "Time2Ti IN  : TIME[%lf](%s)\n", In_sec, wk ) ;
	/****************************************************************/
	rtn = Time2Ti( In_sec, &IntTI, &ETI );
	/****************************************************************/
	if( rtn < 0 ) {
		printf( "Time2Ti error [%d]\n", rtn );
		exit(1);
	}
	printf( "Time2Ti OUT : rtn[%d] TI[%08x] ETI[%d]\n", rtn, IntTI, ETI );

	/*--------------------------------------------------------------*/
	In_sec++;
	memset( wk, 0x00, sizeof(wk) );
    rtn = TT2ASCUT( 1, In_sec, wk );
	dtmedt( wk );
	printf( "Time2Ti IN  : TIME[%lf](%s)\n", In_sec, wk ) ;
	rtn = Time2Ti( In_sec, &IntTI, &ETI );
	printf( "Time2Ti OUT : rtn[%d] TI[%08x] ETI[%d]\n", rtn, IntTI, ETI );

}
int    dtmedt( char *wk ) {

    char        cwk[30];

    memset( cwk, 0x00, sizeof(cwk) );
    strncpy( cwk, &wk[0], 4 );
    strcat( cwk, "." );
    strncat( cwk, &wk[4], 2 );
    strcat( cwk, "." );
    strncat( cwk, &wk[6], 2 );
    strcat( cwk, " " );
    strncat( cwk, &wk[8], 2 );
    strcat( cwk, ":" );
    strncat( cwk, &wk[10], 2 );
    strcat( cwk, ":" );
    strncat( cwk, &wk[12], 2 );
    strcat( cwk, "." );
    strncat( cwk, &wk[14], 3 );
    strcat( cwk, "." );
    strncat( cwk, &wk[17], 3 );

    memset( wk, 0x00, sizeof(wk) );
    strcpy( wk, cwk );

	return(0);
}
