/**********************************
 *     
 *      TIME CHECK TEST MAIN
 *
 *      testWTI2TIME 99999999 yyyymmddhhmmss
 *      testWTI2TIME 0xFFFFFFFF yyyymmddhhmmss
 *
 **********************************/
#include        <stdio.h>
#include        <stdlib.h>
#include        <string.h>
#include        <inttypes.h>
#include        "TiTm_type.h"

int    dtmedt( char *wk );

int    main( argc, argv )
int32_t     argc;
char    *argv[];
{

	char 		INTI[30];
	uint8_t 	TI[30], TIME[30];
	char  		INTIME[30];
	char  		cwk[30], *fname1, *fname2;
	char		*cdmy;

	int 		ir, rtn;
	uint64_t 	llint;
	uint32_t 	IntTI;
	uint16_t 	ETI;
	double 		Sec, In_Sec;

	/*--------------------------------------------------------------*/
	/* 入力パラメータの解析						*/
	/*--------------------------------------------------------------*/
	if( argc != 3 ) {
		printf( "Usage : testWTI2TIME 0xffffffff/99999999 yyyymmddhhmmss\n" );
		exit(1);
	}

	if( strlen(argv[1]) > 11 ) {
		printf( "TI(0xffffffff/99999999) length error\n" );
		exit(1);
	}
	strcpy( INTI, argv[1] );
	llint = strtoll( INTI, &cdmy, 0 );
	if( (*cdmy != '\0') || (llint>0xffffffffLL) ) {
		printf( "TI(0xffffffff/99999999) code error [%s]\n", INTI );
		exit(1);
	}
	IntTI = llint;

	if( strlen(argv[2]) != 14 ) {
		printf( "TIME(yyyymmddhhmmss) length error\n" );
		exit(1);
	}
      if( fname1 = getenv( "TM_LEAP_FPATH" ) ){
      }else {
              printf( "environment error :TM_LEAP_FPATH\n" );
              exit(1);
      }

      if( fname2 = getenv( "TM_STD_FPATH" ) ){
      }else {
              printf( "environment error :TM_STD_FPATH\n" );
              exit(1);
      }

	strcpy( INTIME, argv[2] );
	strcat( INTIME, "000000" );
	rtn = ASCUT2TT( 1, INTIME, &In_Sec );
	if( rtn < 0 ) {
		printf( "TIME(yyyymmddhhmmss) error [%s][%d]\n", INTIME, rtn );
		exit(1);
	}



	/*--------------------------------------------------------------*/
	/* Ti2Time() を実行		         			*/
	/*--------------------------------------------------------------*/
	printf( "##### Ti2Time #####\n");
	memset( cwk, 0x00, sizeof(cwk) );
	strcpy( cwk, INTIME );
	dtmedt( cwk );
	printf( "Ti2Time IN  : TI[%08x] TIME[%s]\n", IntTI, INTIME ) ;
	/****************************************************************/
	rtn = Ti2Time( INTIME, IntTI, &Sec, &ETI );
	/****************************************************************/
	printf( "Ti2Time OUT : Time[%lf] ETI[%d]  \n", Sec, ETI ) ;
	if( rtn < 0 ) {
		printf( "Ti2Time error [%d]\n", rtn );
		exit(1);
	}

	/*--------------------------------------------------------------*/
	/* 時刻変換　　　　						*/
	/*--------------------------------------------------------------*/
	/****************************************************************/
	memset( cwk, 0x00, sizeof(cwk) );
	rtn = TT2ASCUT( 1, Sec, cwk );
	/****************************************************************/
	if( rtn < 0 ) {
		printf( "TT2ASCUT error[%d]\n", rtn );
		exit(1);
	}
	dtmedt( cwk );
	printf( "TT2ASCUT OUT: Ut[%s]\n", cwk);
	/*--------------------------------------------------------------*/
	IntTI = IntTI + 0x20;
	memset( cwk, 0x00, sizeof(cwk) );
	strcpy( cwk, INTIME );
	dtmedt( cwk );
	printf( "\nTi2Time IN  : TI[%08x] TIME[%s]\n", IntTI, INTIME ) ;
	rtn = Ti2Time( INTIME, IntTI, &Sec, &ETI );
	printf( "Ti2Time OUT : Time[%lf] ETI[%d]  \n", Sec, ETI ) ;
	memset( cwk, 0x00, sizeof(cwk) );
	rtn = TT2ASCUT( 1, Sec, cwk );
	dtmedt( cwk );
	printf( "TT2ASCUT OUT: Ut[%s]\n", cwk);

    exit( 0 ) ;
}
int    dtmedt( char *wk ) {

    char        cwk[30];

    memset( cwk, 0x00, sizeof(cwk) );
    strncpy( cwk, &wk[0], 4 );
    strcat( cwk, "." );
    strncat( cwk, &wk[4], 2 );
    strcat( cwk, "." );
    strncat( cwk, &wk[6], 2 );
    strcat( cwk, " " );
    strncat( cwk, &wk[8], 2 );
    strcat( cwk, ":" );
    strncat( cwk, &wk[10], 2 );
    strcat( cwk, ":" );
    strncat( cwk, &wk[12], 2 );
    strcat( cwk, "." );
    strncat( cwk, &wk[14], 3 );
    strcat( cwk, "." );
    strncat( cwk, &wk[17], 3 );

    memset( wk, 0x00, sizeof(wk) );
    strcpy( wk, cwk );

	return(0);
}
