/**********************************
 *     
 *      TIME CHECK TEST MAIN
 *
 *      testWETI2TIME 99 0xFFFFFFFF/9999999999 
 *
 **********************************/
#include        <stdio.h>
#include        <stdlib.h>
#include        <string.h>
#include        <inttypes.h>
#include <sys/time.h>
#include        "TiTm_type.h"

int    dtmedt( char *wk );

int    main( argc, argv )
int32_t     argc;
char    *argv[];
{

	uint8_t  	TI[30];
	char  		INTI[30];
	uint8_t  	TIME[30];
	char  		INTIME[30];
	char  		wk[30], *fname1, *fname2;
	char            *cdmy;

	int 		ir, rtn;
	uint64_t 	llint;
	uint32_t 	IntTI;
	uint16_t 	ETI;
	double 		SBsec, In_SBsec;
/***** 時間測定用 *****/
struct timeval  tps, tpe;
time_t  tisa_sec;
suseconds_t tisa_usec;
/***** 時間測定用 *****/

	/*--------------------------------------------------------------*/
	/* 入力パラメータの解析						*/
	/*--------------------------------------------------------------*/
	if( argc != 3 ) {
		printf( "Usage : testWETI2TIME 99 0xFFFFFFFF/9999999999\n" );
		exit(1);
	}
	
	strcpy( INTI, argv[1] );
	llint = strtoll( INTI, &cdmy, 0 );
	if( (*cdmy != '\0') || (llint>0xffffffffLL) ) {
		printf( "ETI(0xffff/999) code error [%s]\n", INTI );
		exit(1);
	}
	ETI = llint;

	if( strlen(argv[2]) > 11 ) {
		printf( "TI(0xffffffff/99999999) length error\n" );
		exit(1);
	}
	strcpy( INTI, argv[2] );
	llint = strtoll( INTI, &cdmy, 0 );
	if( (*cdmy != '\0') || (llint>0xffffffffLL) ) {
		printf( "TI(0xffffffff/99999999) code error\n" );
		exit(1);
	}

      if( fname1 = getenv( "TM_LEAP_FPATH" ) );
      else {
              printf( "environment error :TM_LEAP_FPATH\n" );
              exit(1);
      }

      if( fname2 = getenv( "TM_STD_FPATH" ) );
      else {
              printf( "environment error :TM_STD_FPATH\n" );
              exit(1);
      }



	IntTI = llint;;
#if 0
	printf( "TI[%s][%llu][%u]\n", INTI, llint, IntTI );
#endif

	/*--------------------------------------------------------------*/
	printf( "##### Eti2Time #####\n");
	printf( "Eti2Time IN  : ETI[%d] TI[%08x] \n", ETI, IntTI ) ;
	/****************************************************************/
/***** 時間測定用 *****/
gettimeofday( &tps, NULL );
/***** 時間測定用 *****/
	rtn = Eti2Time( ETI, IntTI, &SBsec );
/***** 時間測定用 *****/
gettimeofday( &tpe, NULL );
if( tps.tv_usec > tpe.tv_usec ) {
	tisa_sec = tpe.tv_sec - tps.tv_sec - 1;
	tisa_usec = 1000 - (tpe.tv_usec - tps.tv_usec);
} else {
	tisa_sec = tpe.tv_sec - tps.tv_sec;
	tisa_usec = tpe.tv_usec - tps.tv_usec;
}
printf("Eti2Time [%d.%06d]sec\n", tisa_sec, tisa_usec );
/***** 時間測定用 *****/
	/****************************************************************/
	printf( "Eti2Time OUT : rtn[%d] Time[%lf]\n", rtn, SBsec ) ;
	if( rtn < 0 ) {
		printf( "Eti2Time error [%d]\n", rtn );
		exit(1);
	}

	/*--------------------------------------------------------------*/
	/* 時刻に変更　　　　　　					*/
	/*--------------------------------------------------------------*/
	memset( wk, 0x00, sizeof(wk) );
	rtn = TT2ASCUT( 1, SBsec, wk );
	/****************************************************************/
	if( rtn < 0 ) {
		printf( "TT2ASCUT error [%d]\n", rtn );
		exit(1);
	}
	dtmedt( wk );
	printf( "TT2ASCUT OUT : Ut[%s]\n", wk );

#if 0
	sleep( 2*60+1 );
#endif

	/*--------------------------------------------------------------*/
	IntTI = IntTI + 0x20;
	printf( "Eti2Time IN  : ETI[%d] TI[%08x] \n", ETI, IntTI ) ;
/***** 時間測定用 *****/
gettimeofday( &tps, NULL );
/***** 時間測定用 *****/
	rtn = Eti2Time( ETI, IntTI, &SBsec );
/***** 時間測定用 *****/
gettimeofday( &tpe, NULL );
if( tps.tv_usec > tpe.tv_usec ) {
	tisa_sec = tpe.tv_sec - tps.tv_sec - 1;
	tisa_usec = 1000 - (tpe.tv_usec - tps.tv_usec);
} else {
	tisa_sec = tpe.tv_sec - tps.tv_sec;
	tisa_usec = tpe.tv_usec - tps.tv_usec;
}
printf("Eti2Time [%d.%06d]sec\n", tisa_sec, tisa_usec );
/***** 時間測定用 *****/
	printf( "Eti2Time OUT : rtn[%d] Time[%lf]\n", rtn, SBsec ) ;
	memset( wk, 0x00, sizeof(wk) );
	rtn = TT2ASCUT( 1, SBsec, wk );
	dtmedt( wk );
	printf( "TT2ASCUT OUT : Ut[%s]\n", wk );

    exit( 0 ) ;
}

int	dtmedt( char *wk ) {

	char  		cwk[30];

	memset( cwk, 0x00, sizeof(cwk) );
	strncpy( cwk, &wk[0], 4 );
	strcat( cwk, "." );
	strncat( cwk, &wk[4], 2 );
	strcat( cwk, "." );
	strncat( cwk, &wk[6], 2 );
	strcat( cwk, " " );
	strncat( cwk, &wk[8], 2 );
	strcat( cwk, ":" );
	strncat( cwk, &wk[10], 2 );
	strcat( cwk, ":" );
	strncat( cwk, &wk[12], 2 );
	strcat( cwk, "." );
	strncat( cwk, &wk[14], 3 );
	strcat( cwk, "." );
	strncat( cwk, &wk[17], 3 );

	memset( wk, 0x00, sizeof(wk) );
	strcpy( wk, cwk );

	return(0);
}
