/**********************************
 *     
 *  Ut to Tt TIME CHECK TEST MAIN
 *
 *    testUT2TT  YYYYMMDDhhmmssmsmsmsususus
 *
 **********************************/
#include        <stdio.h>
#include        <stdlib.h>
#include        <string.h>
#include        "TimeCal_type.h"
#include        "Com_type.h" /* ADD 2023.07.31 */

int main( argc, argv )
int32_t     argc;
char    *argv[];
{
  	char a_ut[21], aa_ut[21];
  	char cwk[30], *fname;
  	uint8_t b_ut[11], bb_ut[11];
	char *Leap_FNAME;

	int leng = 20;
	int N1 = 1;
  	int rtn, i;
  	int ir;
  	double Ttsec = 0.0;

	int yy, mm, dd;
	static int month[12]={31, 0, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

/*------------------------------------------------------*/
	if( argc != 2 ) {
		printf( "Usage : testUTC2ES YYYYMMDDhhmmssmmmuuu\n" );
		exit(1);
	}

	if( strlen(argv[1]) != 20 ) {
		printf( "YYYYMMDDhhmmssmmmuuu length(20) error\n" );
		exit(1);
	}


      if( fname = getenv( "TM_LEAP_FPATH" ) );
      else {
              printf( "environment error :TM_LEAP_FPATH\n" );
              exit(1);
      }

	rtn = setLeapSecFile(fname);


	strcpy( a_ut, argv[1] );
	strcpy( aa_ut, argv[1] );

/*------------------------------------------------------*/
	/* トータル日算出 */
	memset( cwk, 0x00, sizeof(cwk) );
	memcpy( cwk, a_ut, 4 );
	yy = atoi( cwk );
	memset( cwk, 0x00, sizeof(cwk) );
	memcpy( cwk, &a_ut[4], 2 );
	mm = atoi( cwk );
	memset( cwk, 0x00, sizeof(cwk) );
	memcpy( cwk, &a_ut[6], 2 );
	dd = atoi( cwk );

	for( i=0; i<mm-1; i++ ) {
		if( i == (2-1) ) {
			if( yy%4 == 0 ) {
				month[i] = 29;
			} else {
				month[i] = 28;
			}
		}
		dd = dd + month[i];
	} 
	sprintf( cwk, "%04d", dd );
	memcpy( &aa_ut[4], cwk, 4 );

/*------------------------------------------------------*/
	printf( "##### utc2es #####\n");
	printf( "utc2es IN  : Ut(ASCII)[%c%c%c%c.%c%c.%c%c %c%c:%c%c:%c%c.%c%c%c.%c%c%c]\n",
		a_ut[0],a_ut[1],a_ut[2],a_ut[3],a_ut[4],a_ut[5],a_ut[6],a_ut[7],a_ut[8],a_ut[9],a_ut[10],
		a_ut[11],a_ut[12],a_ut[13],a_ut[14],a_ut[15],a_ut[16],a_ut[17],a_ut[18],a_ut[19]);
  	rtn = utc2es( 1, a_ut, &Ttsec );
	printf( "utc2es OUT : rtn[%d] Tt[%lf]   \n" ,rtn, Ttsec);

	printf( "utc2es IN  : Ut(ASCII)[%c%c%c%c.%c%c%c%c %c%c:%c%c:%c%c.%c%c%c.%c%c%c]\n",
		aa_ut[0],aa_ut[1],aa_ut[2],aa_ut[3],aa_ut[4],aa_ut[5],aa_ut[6],aa_ut[7],aa_ut[8],aa_ut[9],aa_ut[10],
		aa_ut[11],aa_ut[12],aa_ut[13],aa_ut[14],aa_ut[15],aa_ut[16],aa_ut[17],aa_ut[18],aa_ut[19]);
  	rtn = utc2es( 2, aa_ut, &Ttsec );
	printf( "utc2es OUT : rtn[%d] Tt[%lf]   \n" ,rtn, Ttsec);
	
/*------------------------------------------------------*/
	printf( "##### utcbcd2es #####\n");
	rtn = com_ascbcd_( a_ut, b_ut, &leng, &ir, &N1, &N1);
	if( rtn < 0 ){
		printf("ASCII -> BCD ERROR !\n");
		exit(1);
	}
	printf( "utcbcd2es IN  : Ut(BCD)[%02x%02x.%02x.%02x %02x:%02x:%02x %02x%02x%02x]\n", 
		b_ut[0],b_ut[1],b_ut[2],b_ut[3],b_ut[4],b_ut[5],b_ut[6],b_ut[7],b_ut[8],b_ut[9]);
  	rtn = utcbcd2es( 1, b_ut, &Ttsec );
	printf( "utcbcd2es OUT : rtn[%d] Tt[%lf]   \n", rtn, Ttsec);

	rtn = com_ascbcd_( aa_ut, bb_ut, &leng, &ir, &N1, &N1);
	if( rtn < 0 ){
		printf("ASCII -> BCD ERROR !\n");
		exit(1);
	}
	printf( "utcbcd2es IN  : Ut(BCD)[%02x%02x.%02x%02x %02x:%02x:%02x %02x%02x%02x]\n", 
		bb_ut[0],bb_ut[1],bb_ut[2],bb_ut[3],bb_ut[4],bb_ut[5],bb_ut[6],bb_ut[7],bb_ut[8],bb_ut[9]);
  	rtn = utcbcd2es( 2, bb_ut, &Ttsec );
	printf( "utcbcd2es OUT : rtn[%d] Tt[%lf]   \n", rtn, Ttsec);

}
int    dtmedt( char *wk ) {

    char        cwk[30];

    memset( cwk, 0x00, sizeof(cwk) );
    strncpy( cwk, &wk[0], 4 );
    strcat( cwk, "." );
    strncat( cwk, &wk[4], 2 );
    strcat( cwk, "." );
    strncat( cwk, &wk[6], 2 );
    strcat( cwk, " " );
    strncat( cwk, &wk[8], 2 );
    strcat( cwk, ":" );
    strncat( cwk, &wk[10], 2 );
    strcat( cwk, ":" );
    strncat( cwk, &wk[12], 2 );
    strcat( cwk, "." );
    strncat( cwk, &wk[14], 3 );
    strcat( cwk, "." );
    strncat( cwk, &wk[17], 3 );

    memset( wk, 0x00, sizeof(wk) );
    strcpy( wk, cwk );

	return(0);
}
