/**********************************
 *     
 *  Tt to Ut TIME CHECK TEST MAIN
 *
 *    testTT2UT  999999.999999 (totalsec)
 *
 **********************************/
#include        <stdio.h>
#include        <stdlib.h>
#include        <string.h>
#include        "TimeCal_type.h"

int    dtmedt( int flg, char *wk ); /* ADD 2023.07.31 */

int main( argc, argv )
int32_t     argc;
char    *argv[];
{
  	uint8_t wk[20];
  	char cwk[20], *fname;
  	int rtn;
  	double Ttsec;

/*------------------------------------------------------*/
	if( argc != 2 ) {
		printf( "Usage : testES2UTC 999999.99999\n" );
		exit(1);
	}

	Ttsec = atof( argv[1] );

      if( fname = getenv( "TM_LEAP_FPATH" ) );
      else {
              printf( "environment error :TM_LEAP_FPATH\n" );
              exit(1);
      }

        rtn = setLeapSecFile(fname);


	memset( cwk, 0x00, sizeof(cwk) );
/*------------------------------------------------------*/
	printf( "##### es2utc #####\n");
	printf( "es2utc IN  : Tt[%lf]\n", Ttsec );

	rtn = es2utc( 1, Ttsec, cwk );
	dtmedt( 1, cwk );
	printf( "es2utc OUT : rtn[%d] Ut[%s]\n",rtn, cwk);

	rtn = es2utc( 2, Ttsec, cwk );
	dtmedt( 2, cwk );
	printf( "es2utc OUT : rtn[%d] Ut[%s]\n",rtn, cwk);

/*------------------------------------------------------*/
	printf( "##### es2utcbcd #####\n");
	printf( "es2utcbcd IN  : Tt[%lf]\n", Ttsec );

	rtn = es2utcbcd( 1, Ttsec, wk );
	printf( "es2utcbcd OUT : rtn[%d] Ut[%02x%02x.%02x.%02x %02x:%02x:%02x %02x%02x%02x]\n",rtn, wk[0],wk[1],wk[2],wk[3],wk[4],wk[5],wk[6],wk[7],wk[8],wk[9]);

	rtn = es2utcbcd( 2, Ttsec, wk );
	printf( "es2utcbcd OUT : rtn[%d] Ut[%02x%02x.%02x%02x %02x:%02x:%02x %02x%02x%02x]\n",rtn, wk[0],wk[1],wk[2],wk[3],wk[4],wk[5],wk[6],wk[7],wk[8],wk[9]);

/*------------------------------------------------------*/
	Ttsec = Ttsec + 1.0;
	printf( "##### es2utc #####\n");
	printf( "es2utc IN  : Tt[%lf]\n", Ttsec );

	rtn = es2utc( 1, Ttsec, cwk );
	dtmedt( 1, cwk );
	printf( "es2utc OUT : rtn[%d] Ut[%s]\n",rtn, cwk);

	rtn = es2utc( 2, Ttsec, cwk );
	dtmedt( 2, cwk );
	printf( "es2utc OUT : rtn[%d] Ut[%s]\n",rtn, cwk);

/*------------------------------------------------------*/
	printf( "##### es2utcbcd #####\n");
	printf( "es2utcbcd IN  : Tt[%lf]\n", Ttsec );

	rtn = es2utcbcd( 1, Ttsec, wk );
	printf( "es2utcbcd OUT : rtn[%d] Ut[%02x%02x.%02x.%02x %02x:%02x:%02x %02x%02x%02x]\n",rtn, wk[0],wk[1],wk[2],wk[3],wk[4],wk[5],wk[6],wk[7],wk[8],wk[9]);

	rtn = es2utcbcd( 2, Ttsec, wk );
	printf( "es2utcbcd OUT : rtn[%d] Ut[%02x%02x.%02x%02x %02x:%02x:%02x %02x%02x%02x]\n",rtn, wk[0],wk[1],wk[2],wk[3],wk[4],wk[5],wk[6],wk[7],wk[8],wk[9]);

}
int    dtmedt( int flg, char *wk ) {

    char        cwk[30];

    memset( cwk, 0x00, sizeof(cwk) );
    strncpy( cwk, &wk[0], 4 );
    strcat( cwk, "." );
	if( flg == 1 ) {
    	strncat( cwk, &wk[4], 2 );
    	strcat( cwk, "." );
    	strncat( cwk, &wk[6], 2 );
	} else {
    	strncat( cwk, &wk[4], 4 );
	}
    strcat( cwk, " " );
    strncat( cwk, &wk[8], 2 );
    strcat( cwk, ":" );
    strncat( cwk, &wk[10], 2 );
    strcat( cwk, ":" );
    strncat( cwk, &wk[12], 2 );
    strcat( cwk, "." );
    strncat( cwk, &wk[14], 3 );
    strcat( cwk, "." );
    strncat( cwk, &wk[17], 3 );

    memset( wk, 0x00, sizeof(wk) );
    strcpy( wk, cwk );

	return(0);
}
