/**********************************
 *
 *      Time2Ti CHECK TEST MAIN
 *
 *      testTime2Ti totalsec(double)
 *
 **********************************/
#include        <stdio.h>
#include        <stdlib.h>
#include        <string.h>
#include        "TimeCal_type.h"

int    dtmedt( char *wk ); /* ADD 2023.07.31 */

int    main( argc, argv )
int     argc;
char    *argv[];
{

        char   		wk[30], *fname1, *fname2;

	int 		rtn;
	uint32_t 	ETI;
	uint64_t 	IntTI;
	double 		In_sec;

	/*--------------------------------------------------------------*/
	/* 入力パラメータの解析						*/
	/*--------------------------------------------------------------*/
	if( argc != 2 ) {
		printf( "Usage : testES2ETC totalsec(double)\n" );
		exit(1);
	}


      if( fname1 = getenv( "TM_LEAP_FPATH" ) );
      else {
              printf( "environment error :TM_LEAP_FPATH\n" );
              exit(1);
      }

        rtn = setLeapSecFile(fname1);

	if(rtn != 0){
		printf( "setLeapSecFile error[%d] \n", rtn );
              exit(1);
	}

      if( fname2 = getenv( "TM_STD_FPATH" ) );
      else {
              printf( "environment error :TM_STD_FPATH\n" );
              exit(1);
      }

        rtn = setTimeCalFile(fname2);

	if(rtn != 0){
		printf( "setTimeCalFile error[%d] \n", rtn );
              exit(1);
	}

        In_sec = atof( argv[1] );

        /*--------------------------------------------------------------*/
        /* 時刻に変換　　　　                                           */
        /*--------------------------------------------------------------*/
        /****************************************************************/
		memset( wk, 0x00, sizeof(wk) );
        rtn = es2utc( 1, In_sec, wk );
        /****************************************************************/
        if( rtn < 0 ) {
                printf( "es2utc error [%d]\n", rtn );
                exit(1);
        }else if(rtn > 0){
                printf( "es2utc warn [%d]\n", rtn );
	}
	/*--------------------------------------------------------------*/
	/* es2etc() を実行					*/
	/*--------------------------------------------------------------*/
	printf( "##### es2etc #####\n");
	dtmedt( wk );
	printf( "es2etc IN  : TIME[%lf](%s)\n", In_sec, wk ) ;
	/****************************************************************/
	rtn = es2etc( In_sec, &IntTI, &ETI );
	/****************************************************************/
	if( rtn < 0 ) {
		printf( "es2etc error [%d]\n", rtn );
		exit(1);
        }else if(rtn > 0){
                printf( "es2etc warn [%d]\n", rtn );
	}
	printf( "es2etc OUT : rtn[%d] TI[%016llx] ETI[%d]\n", rtn, IntTI, ETI );

	/*--------------------------------------------------------------*/
	In_sec++;
	memset( wk, 0x00, sizeof(wk) );
    rtn = es2utc( 1, In_sec, wk );
	dtmedt( wk );
	printf( "es2etc IN  : TIME[%lf](%s)\n", In_sec, wk ) ;
	rtn = es2etc( In_sec, &IntTI, &ETI );
	printf( "es2etc OUT : rtn[%d] TI[%016llx] ETI[%d]\n", rtn, IntTI, ETI );

}
int    dtmedt( char *wk ) {

    char        cwk[30];

    memset( cwk, 0x00, sizeof(cwk) );
    strncpy( cwk, &wk[0], 4 );
    strcat( cwk, "." );
    strncat( cwk, &wk[4], 2 );
    strcat( cwk, "." );
    strncat( cwk, &wk[6], 2 );
    strcat( cwk, " " );
    strncat( cwk, &wk[8], 2 );
    strcat( cwk, ":" );
    strncat( cwk, &wk[10], 2 );
    strcat( cwk, ":" );
    strncat( cwk, &wk[12], 2 );
    strcat( cwk, "." );
    strncat( cwk, &wk[14], 3 );
    strcat( cwk, "." );
    strncat( cwk, &wk[17], 3 );

    memset( wk, 0x00, sizeof(wk) );
    strcpy( wk, cwk );

	return(0);
}
