#!/bin/sh

TEST="./test.sh ./testUtTt.sh ./testWUtTt.sh ./testWrap.sh"
TEST_FLAG=0
for i in $TEST
do
	################
	# pre-process
	################
	##string_filename=${i##*/}
	##string_filename_without_extension=${string_filename%.*}
	##string_count=${#string_filename}
	string_filename=`echo $i | awk -F'/' '{ print $NF }'`
	string_filename_without_extension=`echo $string_filename | awk -F'.' '{ print $1 }'`
	string_count=`echo $string_filename_without_extension | awk '{ print length($1) }'`
	printf "$string_filename"
	while [ $string_count -ne 16 ]
	do
		printf "."
		string_count=`expr $string_count + 1`
	done
	log_file=$string_filename_without_extension.log
	ref_file=$string_filename_without_extension.ref
	diff_file=$string_filename_without_extension.diff
	################
	## run-test
	################
	$i > $log_file.org
	################
	# post-process
	################
	sed 's/\[[0-9].[0-9]\{6\}\]sec$/\[S.SSSSSS\]sec/' $log_file.org > $log_file
	/usr/bin/diff $ref_file $log_file > $diff_file
	if [ ! -s $diff_file ]
	then
		printf "ok\n"
		/bin/rm $diff_file
	else
		printf "ng\n"
		cat $diff_file
		TEST_FLAG=1
	fi
done

# PASS/FAIL
exit $TEST_FLAG

