/*******************************************************************

ＵＴＣ(BCD)→経過秒変換処理	  種別：sub

   Program-Name  : utcbcd2es

   Calling Sequence :
    
      int  utcbcd2es( int Kind,  const uint8_t utc_bcd[10],  double *elapsed_seconds );

      In : int Kind : 1 : YYYYMMDDhhmmssmsmsmsususus 
                      2 : YYYY0DDDhhmmssmsmsmsususus 
      In : uint8_t utc_bcd[10] : 
      Out : double *elapsed_seconds : TotalTime (sec)

      Return : 
		RET_NORMAL					：正常終了
		RET_PARAM_ERR				：入力パラメータチェックエラー
		RET_FILE_UNSET_ERR			：ファイルパス未設定
		RET_FILE_OPEN_ERR			：ファイルオープンエラー
		RET_FILE_READ_ERR			：ファイルリードエラー

   Date : 2010/02/17  共通化
          2012/11/15  Ver2.0 y.yoneda  インデントの調整
		  2012/11/21  Ver2.0 y.yoneda  Ver2.0 対応
		  2014/09/01  Ver3.0.2 fae     変数初期化

*******************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	"UtTt.h"
#include	"TimeCal_type.h"	/* Chg Ver2.0 */
#include	"Com_type.h"


int  utcbcd2es( int Kind,  const uint8_t utc_bcd[10],  double *elapsed_seconds ) {

	/****************************************************************/
	/* 領域定義														*/
	/****************************************************************/

	char ut[21];		/*パラメータの UT */
	int leng;		/* com_ascbcdのバイト長 10 */
	int ispos, iepos;	/* com_ascbcdのpointer */
	int ir;

	double Ttsec;		/* トータル秒の計算後格納 */

	/*--------------------------------------------------------------*/
	/*	UT → 衛星時刻 変換を行う。									*/
	/*--------------------------------------------------------------*/

	/* Add Ver2.0 param check */
	if(elapsed_seconds == NULL) {
		return(RET_PARAM_ERR);
	}

#ifdef DBG_TITM
	printf( "[%s:%d] utcbcd2es[%02x%02x.%02x%02x %02x:%02x:%02x %02x%02x%02x]   \n",
	__FILE__ , __LINE__, utc_bcd[0],utc_bcd[1],utc_bcd[2],utc_bcd[3],utc_bcd[4],utc_bcd[5],utc_bcd[6],utc_bcd[7],utc_bcd[8],utc_bcd[9] ) ;
#endif
	leng = 20;
	ispos = 1;
	iepos = 1;
	memset(ut, 0, sizeof(ut));	/* Add Ver3.0.2 */
	com_hexasc_(utc_bcd, ut, &leng, &ispos, &iepos);		/* Chg Ver2.0 */
	ir =  utc2es( Kind, ut, &Ttsec );		/* Chg Ver2.0 */

	if( ir != RET_NORMAL ) {		/* Chg Ver2.0 */
		return(ir);	
	} else {
		*elapsed_seconds = Ttsec;		/* Chg Ver2.0 */
	}
#ifdef DBG_TITM
	printf( "[%s:%d] utcbcd2es    [%lf]   \n", __FILE__ , __LINE__, Ttsec ) ;
#endif

	return(RET_NORMAL);			/* Chg Ver2.0 */
}
