/*******************************************************************

ＵＴＣ(ASCII)→経過秒変換処理	  種別：sub

   Program-Name  : utc2es

   Calling Sequence :
    
      int  utc2es( int Kind, const char *utc, double *elapsed_seconds );

      In : int Kind : 1 : YYYYMMDDhhmmss(msmsmsususus) 
                      2 : YYYY0DDDhhmmss(msmsmsususus) 
      In : char utc : 
      Out : double *elapsed_seconds : TotalTime (sec)

      Return : 
		RET_NORMAL					：正常終了
		RET_PARAM_ERR				：入力パラメータチェックエラー
		RET_FILE_UNSET_ERR			：ファイルパス未設定
		RET_FILE_OPEN_ERR			：ファイルオープンエラー
		RET_FILE_READ_ERR			：ファイルリードエラー

   Date : 2010/02/17  共通化
   Update : 2012/02/10  LV0-001 うるう秒の扱いを修正
            2012/11/15  Ver2.0 y.yoneda  インデントの調整
            2012/11/16  Ver2.0 y.yoneda  うるう年チェック方法厳密化
			2012/11/21  Ver2.0 y.yoneda  Ver2.0 対応
            2015/02/24  Ver3.1.0 fae     utcの文字数チェックを追加して14|20bytes固定使用するように修正

*******************************************************************/


#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	"TimeCal_type.h"	/* Chg Ver2.0 */
#include	"UtTt.h"
#include	"Com_type.h"


int  utc2es( int Kind,  const char *utc,  double *elapsed_seconds ) {

	/****************************************************************/
	/* 領域定義														*/
	/****************************************************************/

	static	UtTt	uttt;	/* うるう秒情報読み込み領域 */

	int  ir;
	char ut[21];		/* パラメータの UT 			*/	
	int  leng;		/* com_hexascのバイト長 10 		*/

	char cwk[10];		/* トータルミリ秒とμ秒の抜出しに使用する */
	char *cdmy=NULL;

	int total_year;  	/* トータル年の計算に使用する 		*/
	int total_month;	/* トータル月の計算に使用する 		*/
	int total_day;		/* トータル日の計算に使用する 		*/
	int total_hour;		/* トータル時の計算に使用する 		*/
	int total_min;		/* トータル分の計算に使用する 		*/
	int total_sec;		/* トータル秒の計算に使用する 		*/
	double total_msec;	/* トータルミリ秒とμ秒の計算に使用する	*/
	double Ttsec;		/* トータル秒の計算後格納 		*/
	int Insart_sec;		/* 挿入秒の合計 			*/
// 2012/02/10 LV0-001 ---start--- add うるう秒の扱い修正
	int Uru_Flag = 0;	/* うるう秒が指定                       */
// 2012/02/10 LV0-001 ---end--- add
	int Uru_Nen_Flag = 0;	/* Add Ver2.0 */

	int i;
	int N1=1;
	int N2=1;

	static	int month[12]={31, 0, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

	/* Add Ver2.0 param check *//* Chg Ver3.1.0 utcチェック追加 */
	if( (Kind != 1 && Kind != 2) || utc == NULL || elapsed_seconds == NULL || (strlen(utc) != 14 && strlen(utc) != 20) ) {
		return(RET_PARAM_ERR);
	}

	/****************************************************************/
	/***      うるう秒ファイル読み込み                            ***/
	/****************************************************************/

	ir = UtTt_Init( &uttt );
	if( ir != RET_NORMAL ) {		/* Chg Ver2.0 */
#ifdef DBG_TITM
        printf( "UtTt_Init error [%d]\n", ir );
#endif
		return(ir);
	}

	/********************************************************************/
	/***                      トータル時刻計算                        ***/
	/********************************************************************/

	/****************************************************************/
	/* UTCを経過秒に変換する										*/
	/****************************************************************/

	memset( ut, 0, sizeof(ut) );
	memcpy( ut, utc, strlen(utc) );		/*  Chg Ver2.0 *//* Chg Ver3.1.0 strcpy -> memcpy */

	/*---------------------------------------------------------------*/
	/* YYYY の 変換 						 						 */
	/*---------------------------------------------------------------*/
	/* 年月日の抜出す。*/
	/* UTCのYYYYを抜出す*/
	memset(cwk, 0, sizeof(cwk) );
	strncpy(cwk, ut, 4);

	/*文字型からint型に変換する。*/
	total_year = strtol(cwk, &cdmy, 10);
	if( (*cdmy != '\0') || (total_year<2000) ) {
#ifdef DBG_TITM
		printf( "utc2es[%d] Year Error [%s]\n", __LINE__, cwk ) ;
#endif
		return(RET_PARAM_ERR);  	/* Chg Ver2.0 */
	}

	/*---------------------------------------------------------------*/
	/* 0DDD の 変換 						 						 */
	/*---------------------------------------------------------------*/
	/* UTCのDDDを抜出す。*/
	memset(cwk, 0, sizeof(cwk) );
	if( (total_year % 4) == 0 && ((total_year % 100) != 0 || (total_year % 400) == 0) ) {	/* Add Ver2.0 */
		Uru_Nen_Flag = 1;																	/* Add Ver2.0 */
	}
	if( Kind == 1 ) {
		strncpy(cwk, &ut[4], 2);
		total_month = strtol(cwk, &cdmy, 10);
		if( (*cdmy != '\0') || (1 > total_month) || (12 < total_month) ){
#ifdef DBG_TITM
			printf( "utc2es[%d] Month Error [%s]\n", __LINE__, cwk ) ;
#endif
			return(RET_PARAM_ERR);  	/* Chg Ver2.0 */
		}
		if( Uru_Nen_Flag == 1 ) {		/* Chg Ver2.0 */
			month[2-1] = 29;
		} else {
			month[2-1] = 28;
		}
		total_hour = 0;
		for( i=0; i<total_month-1; i++ ) {
			total_hour = total_hour + month[i];
		}
		strncpy(cwk, &ut[6], 2);
		total_day = strtol(cwk, &cdmy, 10);
		if( (*cdmy != '\0') || (1 > total_day) || (month[total_month-1] < total_day)){
#ifdef DBG_TITM
			printf( "utc2es[%d] Month Error [%s]\n", __LINE__, cwk ) ;
#endif
			return(RET_PARAM_ERR);  	/* Chg Ver2.0 */
		}
		total_day = total_hour + total_day;
	} else {
		strncpy(cwk, &ut[5], 3);

		/* 文字型からint型に変換する。*/
		total_day = strtol(cwk, &cdmy, 10);

		/* 日数のチェック */
		if( (*cdmy != '\0') || (1 > total_day) || (Uru_Nen_Flag == 1 && 366 < total_day) || (Uru_Nen_Flag != 1 && 365 < total_day) ){	/* Chg Ver2.0 */
#ifdef DBG_TITM
			printf( "utc2es[%d] Day Error [%s]\n", __LINE__, cwk ) ;
#endif
			return(RET_PARAM_ERR);  	/* Chg Ver2.0 */
		}
	}

	/*--------------------------------------------------------------*/
	/* HH の 変換 						 							*/
	/*--------------------------------------------------------------*/
	/* UTCのhhを抜出す。*/
	memset(cwk, 0, sizeof(cwk) );
	strncpy(cwk, &ut[8], 2);
	/* 文字型からint型に変換する。*/
	total_hour = strtol(cwk, &cdmy, 10);
	if( (*cdmy != '\0') || ( 0 > total_hour) || (23 < total_hour) ){
#ifdef DBG_TITM
		printf( "utc2es[%d] Hour Error [%s] \n", __LINE__, cwk ) ;
#endif
		return(RET_PARAM_ERR);  	/* Chg Ver2.0 */
	}

	/*--------------------------------------------------------------*/
	/* mm の 変換 						 							*/
	/*--------------------------------------------------------------*/
	/* UTCのmmを抜出す。*/
	memset(cwk, 0, sizeof(cwk) );
	strncpy(cwk, &ut[10], 2);
	/* 文字型からint型に変換する。*/
	total_min = strtol(cwk, &cdmy, 10);
	if( (*cdmy != '\0') || ( 0 > total_min) || (59 < total_min) ){
#ifdef DBG_TITM
		printf( "utc2es[%d] Min Error [%s]\n", __LINE__, cwk ) ;
#endif
		return(RET_PARAM_ERR);  	/* Chg Ver2.0 */
	}

	/*--------------------------------------------------------------*/
	/* ss の 変換 						 							*/
	/*--------------------------------------------------------------*/
	/* UTCのssを抜出す。*/
	memset(cwk, 0, sizeof(cwk) );
	strncpy(cwk, &ut[12], 2);
	/* 文字型からint型に変換する。*/
	total_sec = strtol(cwk, &cdmy, 10);
	if( (*cdmy != '\0') || ( 0 > total_sec) || (59 < total_sec) ){
// 2012/02/10 LV0-001 ---start--- add うるう秒の扱い修正
		/* 60secを指定されていた場合はうるう秒指定と仮定する */
		if( total_sec == 60 ) {
			Uru_Flag = 1;
		} else {
// 2012/02/10 LV0-001 ---end--- add 
#ifdef DBG_TITM
			printf( "utc2es[%d] Sec Error [%s] \n", __LINE__, cwk ) ;
#endif
			return(RET_PARAM_ERR);  	/* Chg Ver2.0 */
		}
	}

	/*--------------------------------------------------------------*/
	/* msmsmsμsμsμs の 変換 										*/
	/*--------------------------------------------------------------*/
	/* UTCのmsmsmsμsμsμsを抜出す。*/
	memset(cwk, 0, sizeof(cwk) );
	strncpy(cwk, &ut[14], 6);
	/* 文字型からfloat型に変換する。*/
	total_msec = strtol(cwk, &cdmy, 10);
    if( (*cdmy != '\0') || ( 0 > total_msec) ){
#ifdef DBG_TITM
		printf( "utc2es[%d] Msec Usec Error [%s] \n", __LINE__, cwk ) ;
#endif
		return(RET_PARAM_ERR);  	/* Chg Ver2.0 */
    }

	/* 1000000で割る。(0.msmsmsusususにする) */
	total_msec /= 1000000.0;

	/*--------------------------------------------------------------*/
	/* トータル秒の計算を行う。										*/
	/*--------------------------------------------------------------*/
	/* YYYYから2000を引きトータル年を計算する。*/
	total_year -= 2000;

	/* トータル年からトータル日に変換する。*/
	for(i = 0; i < total_year; i++){
		if( ( i % 4) == 0 && ((i % 100) != 0 || (i % 400) == 0) ){		/* うるう年の判定 *//* Chg Ver2.0 */
			/* トータル日に366日を加算 */
			total_day += 366;
		}else{
			/* トータル日に365日を加算 */
			total_day += 365;
		
		} 
	}
	/* 0DDDから01を引き、トータル日に加算する。*/
	total_day -= 1;
	/* トータル秒計算*/
	Ttsec = (((total_day * 24) + total_hour) * 60 + total_min ) * 60 + total_sec + total_msec;
	if(total_year < 0){
		Ttsec -= (60 * 60 * 24 * 365);
	}

	/****************************************************************/
	/* うるう秒の計算												*/
	/****************************************************************/
	/* メモリ上のトータル秒版うるう秒と照合する。			*/
	/* UTC→経過秒変換は、UTCとうるう秒テーブルの挿入			*/
	/*	される時刻がトータル秒同士なので、挿入秒		*/
	/*	の合計を求めてから加算する。				*/

	Insart_sec = 0;
	for(i = 0; i < uttt.UtTt_uruu_rdcnt; i++){
// 2012/02/10 LV0-001 ---start--- add うるう秒の扱い修正
		/* hh:mm:60指定ならばうるう秒時刻でもうるう秒を加算しない */
		if( Uru_Flag == 1 ) {
			if( (int)Ttsec == (int)uttt.UtTt_uruu_tbl[i].Total_sec ) {
				Uru_Flag = 2;
				break;
			}
		}
		/* hh:mm:00指定ならばうるう秒時刻はうるう秒を加算 */
		if(Ttsec >= uttt.UtTt_uruu_tbl[i].Total_sec){
// 2012/02/10 LV0-001 ---end--- add
			/* 挿入秒の合計 */
			Insart_sec += uttt.UtTt_uruu_tbl[i].uruu_sec;
		}
	}
// 2012/02/10 LV0-001 ---start--- add うるう秒の扱い修正
	/* hh:mm:60指定でうるう秒時刻でなかったらエラーとする。 */
	if( Uru_Flag == 1 ) {
#ifdef DBG_TITM
		printf( "utc2es[%d] Sec Error [%s] \n", __LINE__, cwk ) ;
#endif
		return(RET_PARAM_ERR);  	/* Chg Ver2.0 */
	}
// 2012/02/10 LV0-001 ---end--- add

	/*--------------------------------------------------------------*/
	/* 挿入秒を加算する。											*/
	/*--------------------------------------------------------------*/
	Ttsec += Insart_sec;

   /**********************/
   /*** 復帰情報を返す ***/
   /**********************/
	/* 正常終了 */

#ifdef DBG_TITM
	printf( "[%s:%d]  変換成功  Ttsec[%f]    \n", __FILE__ , __LINE__, Ttsec ) ;
#endif
//	if( Ttsec < 0 ) {	/* Del Ver2.0 常にfalse */
//		return(-99);  
//	} else {
		*elapsed_seconds = Ttsec;
//	}

	return(RET_NORMAL);		/* Chg Ver2.0 */
}

