/**********************************************************************

    Time Code合成関数		                          種別：sub

    (1)処理概要
	    Message Time、Packet Timeおよび補間ビット数を指定し、Message TimeとPacket Timeを合成した値を返却する。

    (2)呼出形式
            uint64_t recover_missing_bits(uint64_t msg_time,uint32_t pkt_time,unsigned int num_missing_bits)

    (3)パラメタ説明
	    ・ mng_time (入力／uint64_t)
		   補間する対象のMessage Time。

	    ・ pkt_time (入力／uint32_t)
		   補間する時刻情報を含むPacket Time。

	    ・ num_missing_bits (入力／unsigned int)
		   補間ビット数。

	    ・ 復帰値 (出力／uint64_t)
				Message Time、Packet Timeの合成結果。

    (4) 作成日 2018/12/06  Ver3.3.0  jex)miyadera  フレーム方式対応

***********************************************************************/
#include <stdio.h>
#include "TimeCal_type.h"

uint64_t recover_missing_bits(uint64_t msg_time, uint32_t pkt_time, unsigned int num_missing_bits){

   uint64_t pkt_time64;
   int64_t diff;

#ifdef DBG_TITM
	printf("recover_missing_bits arg1 : msg_time[%llu](0x%016llx)\n", msg_time, msg_time);
	printf("recover_missing_bits arg2 : pkt_time[%lu](0x%08x)\n", pkt_time, pkt_time);
	printf("recover_missing_bits arg3 : num_bits[%d]\n", num_missing_bits);
#endif

   pkt_time64 = pkt_time;
   pkt_time64 <<= 32;

   diff = msg_time - pkt_time64;

#ifdef DBG_TITM
	printf("recover_missing_bits : pkt_time64[%llu](0x%016llx)\n", pkt_time64, pkt_time64);
	printf("recover_missing_bits : diff      [%llu](0x%016llx)\n", diff, diff);
#endif

   // sign expanssion of upper num_missing_bits

   diff <<= num_missing_bits;
   diff >>= num_missing_bits;

#ifdef DBG_TITM
	printf("recover_missing_bits : diff(shift%d) [%llu](0x%016llx)\n", num_missing_bits, diff, diff);
#endif

   pkt_time64 += diff;

#ifdef DBG_TITM
	printf("recover_missing_bits : return value [%llu](0x%016llx)\n", pkt_time64, pkt_time64);
#endif

   return pkt_time64;
}

