/*******************************************************************

経過秒→ＵＴＣ(BCD)変換処理	  種別：sub

   Program-Name  : es2utcbcd

   Calling Sequence :
    
      int es2utcbcd( int Kind, double elapsed_seconds, uint8_t *utc_bcd );

      In : int Kind : 1 : YYYYMMDDhhmmssmsmsmsususus 
                      2 : YYYY0DDDhhmmssmsmsmsususus 
      In : double elapsed_seconds : TotalTime (sec)
      Out : uint8_t utc_bcd : 10bytes

      Return : 
		RET_NORMAL					：正常終了
		RET_PARAM_ERR				：入力パラメータチェックエラー
		RET_FILE_UNSET_ERR			：ファイルパス未設定
		RET_FILE_OPEN_ERR			：ファイルオープンエラー
		RET_FILE_READ_ERR			：ファイルリードエラー
		RET_CALC_ERR				：算出不可

   Date : 2010/02/17  共通化
          2012/11/15  Ver2.0 y.yoneda  インデントの調整
		  2012/11/21  Ver2.0 y.yoneda  Ver2.0 対応
		  2014/09/01  Ver3.0.2 fae     変数初期化

*******************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	"UtTt.h"
#include	"TimeCal_type.h"	/* Chg Ver2.0 */
#include	"Com_type.h"


int es2utcbcd( int Kind, double elapsed_seconds, uint8_t *utc_bcd ) {

	/****************************************************************/
	/* 領域定義							*/
	/****************************************************************/
			
	char charwk[30];
	int leng;		/* com_ascbcdのバイト長 10 */
	int ispos, iepos;	/* com_ascbcdのpointer */
	int i, ir;

	/* Add Ver2.0 パラメータチェック */
	if( (Kind != 1 && Kind != 2) || elapsed_seconds < 0 || utc_bcd == NULL ){
		return(RET_PARAM_ERR);
	}

	/*--------------------------------------------------------------*/
	/*	衛星時刻 → UT 変換を行う。				*/
	/*--------------------------------------------------------------*/

#ifdef DBG_TITM
	printf( "[%s:%d] es2utcbcd    [%lf]\n", __FILE__ , __LINE__, elapsed_seconds ) ;
#endif

	memset(charwk, 0, sizeof(charwk));	/* Add Ver3.0.2 */
	ir =  es2utc( Kind, elapsed_seconds, charwk );	/* Chg Ver2.0 */
	if( ir != RET_NORMAL ) {	/* Chg Ver2.0 */
		return( ir );
	}

	leng = 20;
	ispos = 1;
	iepos = 1;
	com_ascbcd_( charwk, utc_bcd, &leng, &ir, &ispos, &iepos );	/* Chg Ver2.0 */

#ifdef DBG_TITM
	printf( "[%s:%d] es2utcbcd [%02x%02x.%02x%02x %02x:%02x:%02x.%02x%02x%02x]\n",
			 __FILE__ , __LINE__,
			utc_bcd[0], utc_bcd[1], utc_bcd[2], utc_bcd[3], utc_bcd[4],
			utc_bcd[5], utc_bcd[6], utc_bcd[7], utc_bcd[8], utc_bcd[9]) ;
#endif

	return(RET_NORMAL);	/* Chg Ver2.0 */
}
