/*******************************************************************

衛星時刻→ＵＴＣ(ASCII)変換処理	  種別：sub

   Program-Name  : es2utc

   Calling Sequence :
    
      int  es2utc( int Kind, double elapsed_seconds, char *utc );

      In : int Kind : 1 : YYYYMMDDhhmmss(msmsmsususus) 
                      2 : YYYY0DDDhhmmss(msmsmsususus) 
      In : double elapsed_seconds : TotalTime (sec)
      Out : char utc : 20+1bytes

      Return : 
		RET_NORMAL					：正常終了
		RET_PARAM_ERR				：入力パラメータチェックエラー
		RET_FILE_UNSET_ERR			：ファイルパス未設定
		RET_FILE_OPEN_ERR			：ファイルオープンエラー
		RET_FILE_READ_ERR			：ファイルリードエラー
		RET_CALC_ERR				：算出不可

   Date : 2010/02/17  共通化
   Update : 2012/02/10  LV0-001 うるう秒の扱いを修正
            2012/11/15  Ver2.0 y.yoneda  インデントの調整
            2012/11/16  Ver2.0 y.yoneda  うるう年チェック方法厳密化
			2012/11/21  Ver2.0 y.yoneda  Ver2.0 対応
			2014/11/28  Ver3.0.3 fae     ms以下7桁目の四捨五入修正

*******************************************************************/


#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<inttypes.h>
#include	<limits.h>			/* Add Ver2.0 */
#include	"TimeCal_type.h"	/* Chg Ver2.0 */
#include	"SATCA_com.h"		/* Add Ver2.0 */
#include	"UtTt.h"


int  es2utc( int Kind, double elapsed_seconds, char *utc ) {

	/****************************************************************/
	/* 領域定義							*/
	/****************************************************************/
			
	static  UtTt    uttt;   /* うるう秒情報読み込み領域 */

	int	total_day;	/* トータル日の計算の結果を格納 	*/
	int	YY;		/* 計算した年を格納 			*/
	double 	total_sec;	/* トータル日計算のあまりを格納 	*/
	double 	ttsec;		/* トータル時刻を格納 			*/
	int	hh,mm,ss,ms;	/* 時刻計算用変数 			*/
	int 	MM,DD;		/* 時刻計算用変数 			*/
// 2012/02/10 LV0-001 ---start--- add うるう秒の扱い修正
	int	Uru_Flag = 0;
// 2012/02/10 LV0-001 ---end--- add
	int 	ir, i;
	static	int month[12]={31, 0, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

	/* Add Ver2.0 パラメータチェック */
	if( (Kind != 1 && Kind != 2) || elapsed_seconds < 0 || elapsed_seconds > UINT_MAX || utc == NULL ){
		return(RET_PARAM_ERR);
	}

	/****************************************************************/
	/***      うるう秒ファイル読み込み                            ***/
	/****************************************************************/
	
	ir = UtTt_Init( &uttt );
	if( ir != RET_NORMAL ) {		/* Chg Ver2.0 */
		return(ir);
	}

#ifdef DBG_TITM 
	printf( "[%s:%d] Tt(Sat_Time)[%f]   \n", __FILE__ , __LINE__, elapsed_seconds ) ;
#endif
			
	/*******************************************************************/
	/***                         UTを計算する                        ***/
	/*******************************************************************/
	ttsec = elapsed_seconds;	/* Chg Ver2.0 */

	/****************************************************************/
	/* うるう秒の計算 												*/
	/****************************************************************/
	/* うるう秒テーブル数分ループ 					*/
	for(i = 0; i < uttt.UtTt_uruu_rdcnt; i++){
// 2012/02/10 LV0-001 ---start--- add うるう秒の扱い修正
		/* うるう時刻だったらhh:mm:60表記にする */
		if((int)ttsec == (int)uttt.UtTt_uruu_tbl[i].Total_sec){
			Uru_Flag = 1;
			ttsec -= 1;
			break;
// 2012/02/10 LV0-001 ---end--- add
		/* 「入力されたトータル秒」 > 「うるう秒のトータル秒」 か？ */
		} else if(ttsec > uttt.UtTt_uruu_tbl[i].Total_sec){
			/* 該当すれば1レコードづつ減算する */
			ttsec -= uttt.UtTt_uruu_tbl[i].uruu_sec;
		}
	}
		
	/*--------------------------------------------------------------*/
	/* 年計算 														*/
	/* トータル秒は、 2000/01/01 00時00分00秒 からのトータル秒		*/
	/*--------------------------------------------------------------*/
	YY = 2000;

	/*--------------------------------------------------------------*/
	/* トータル日の計算 											*/
	/* 秒 * 分 * 時 = 1日 											*/
	/*--------------------------------------------------------------*/
	total_day = ttsec / DAY_SEC;							/* Chg Ver2.0 */

	/* トータル日計算のあまりの計算 								*/
	total_sec = ttsec - ( (double)total_day * DAY_SEC );	/* Chg Ver2.0 */
	total_day++;

	/*--------------------------------------------------------------*/
	/* うるう年の計算												*/
	/*--------------------------------------------------------------*/
	while(total_day >= 0){
		if( (YY % 4) == 0 && ((YY % 100) != 0 || (YY % 400) == 0) ){	/* Chg Ver2.0 */
			/* うるう年である */
			if( total_day <= 366 ){
				break;
			}		
			total_day -= 366;
			/* 年をインクリメント */
			YY++;
		}else{	
			/* うるう年ではない */
			if( total_day <= 365 ){
				break;
			}
			total_day -= 365;
			/* 年をインクリメント */
			YY++;
		}
	}

	
	/*--------------------------------------------------------------*/
	/* トータル秒から 時分秒を求める								*/
	/*--------------------------------------------------------------*/
	ss = total_sec;
	ms = (total_sec - ss)*1000000 + 0.5;
	if( ms >= 1000000 ) {	/* Add Ver3.0.3 */
		ms -= 1000000;
		ss++;
	}
	hh = ss / (60*60);
	ss = ss - hh*(60*60);
	mm = ss / 60;
// 2012/02/10 LV0-001 ---start--- add うるう秒の扱い修正
	if( Uru_Flag != 1 ) {
		ss = ss - mm*60;
	/* うるう時刻だったらhh:mm:60表記にする */
	} else {
		ss = 60;
	}
// 2012/02/10 LV0-001 ---end--- add
	
	if( Kind == 1 ) {
							/* トータル日から月日に変換 */
		MM = 1;
		for( i=0; i<12-1; i++ ) {
			if( i == (2-1) ) {
				if( (YY % 4) == 0 && ((YY % 100) != 0 || (YY % 400) == 0) ) {	/* Chg Ver2.0 */
					month[2-1] = 29;
				} else {
					month[2-1] = 28;
				}
			}
			if( total_day <= month[i] ) break;
			total_day = total_day - month[i];
			MM++;
		} 
		sprintf( utc, "%04d%02d%02d%02d%02d%02d%06d", YY,MM,total_day,hh,mm,ss,ms );	/* Chg Ver2.0 */
	} else {
		sprintf( utc, "%04d%04d%02d%02d%02d%06d", YY,total_day,hh,mm,ss,ms );			/* Chg Ver2.0 */
	}
#ifdef DBG_TITM 
	printf( "[%s:%d] Date_Time [%s]   \n", __FILE__ , __LINE__, utc );
#endif
	/**************************/
	/***   復帰情報を返す   ***/
	/**************************/
	/* 正常終了 */
	return(RET_NORMAL);			/* Chg Ver2.0 */

}
