/*******************************************************************

ＵＴＣ(BCD)→経過秒変換処理	  種別：sub

   Program-Name  : BCDUT2TT

   Calling Sequence :

      int  BCDUT2TT( int Kind,  const uint8_t utc_bcd[10],  double *elapsed_seconds );

      In : int Kind : 1 : YYYYMMDDhhmmssmsmsmsususus
                      2 : YYYY0DDDhhmmssmsmsmsususus
      In : uint8_t utc_bcd[10] :
      Out : double *elapsed_seconds : TotalTime (sec)

      Return :
		0			：正常終了
		-1			：入力パラメータチェックエラー
		-11			：ファイルオープンエラー
		-12			：ファイルリードエラー

   Date : 2013/06/01 後方互換関数として新規作成

*******************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<inttypes.h>
#include	"TiTm_type.h"


int  BCDUT2TT( int Kind,  const uint8_t utc_bcd[10],  double *elapsed_seconds ) {

	/****************************************************************/
	/* 領域定義														*/
	/****************************************************************/
	char *leap_file_path;	/* うるう秒ファイルパス */
	int ret, f_ret;

	/*
	 * うるう秒のファイルパス確認
	 * うるう秒ファイルは、utcbcd2es関数内で毎回読み込んでいるので更新確認は行わない
	 */
	if((leap_file_path = getenv(ENV_LEAP_FILE_PATH)) == NULL ){
		/* 環境変数取得エラー */
		return(-11);
	}

	/* うるう秒ファイルパスを設定済みか確認 */
	ret = leapSecFileSetFlagCheck(0);
	if( ret == 0 ){
		ret = setLeapSecFile(leap_file_path);
		/* 戻り値設定 */
		if( ret != RET_NORMAL ){
			return( -11 );
		}
		ret = leapSecFileSetFlagCheck(1);
	}

	/*
	 * utcbcd2es()呼び出し
	 */
	ret = utcbcd2es( Kind, utc_bcd, elapsed_seconds );

	/* 戻り値設定 */
	if( ret == RET_NORMAL ){
		f_ret = 0;
	}else if( ret == RET_PARAM_ERR ){
		f_ret = -1;
	}else if(ret == RET_FILE_UNSET_ERR || ret == RET_FILE_OPEN_ERR ){
		f_ret = -11;
	}else if(ret == RET_FILE_READ_ERR ){
		f_ret = -12;
	}else{
		/* 到達不可 */
		f_ret = -99;
	}

	return(f_ret);

}
