/**********************************************************************

	ETI＝＞経過秒変換処理	                          種別：sub

    (1)処理概要
	    パラメータで指定したETIを衛星時刻に変換して通知する。

    (2)呼出形式
            int Eti2Time ( uint16_t eti_ext, uint32_t eti_base, double *elapsed_seconds )

    (3)パラメタ説明
	    ・ eti_ext (入力／uint16_t)
		   変換するETIを指定する。(単位：サイクル数)

	    ・ eti_base (入力／uint32_t)
		   変換する時刻 (TI) を指定する。値は31.25msec(2^-5sec)

	    ・ elapsed_seconds (出力／double)
		   変換した衛星時刻が格納される。(単位：秒)

	    ・ 復帰値 (出力／int)
				0			：正常終了
				-1			：入力パラメータチェックエラー
				-11			：ファイルオープンエラー
				-12			：ファイルリードエラー
				-99			：算出不可

    (4) 作成日 2013/06/01  後方互換関数として新規作成

***********************************************************************/

#include	<stdio.h>
#include	<errno.h>
#include	<string.h>
#include	<stdlib.h>
#include	<inttypes.h>
#include	"SATCA_com.h"
#include	"TiTm_type.h"

int Eti2Time ( uint16_t eti_ext, uint32_t eti_base, double *elapsed_seconds )
{


	/****************************************************************/
	/* 領域定義														*/
	/****************************************************************/
	char *timecal_file_path, *leap_file_path;	/* ファイルパス */
	int ret, f_ret;
	uint32_t const extZeroSet = 0x00007fff;	/* eti2esに渡すETI拡張部作成用 */
	uint32_t const extFlgSet = 0x80000000;
	uint16_t const extFlgMask = 0x8000;
	uint32_t extVal;

	/*
	 * 衛星時刻校正表ファイルパス確認
	 */
	if((timecal_file_path = getenv(ENV_TIMECAL_FILE_PATH)) == NULL ){
		/* 環境変数取得エラー */
		return(-11);
	}

	/*
         * うるう秒のファイルパス確認
         */
        if((leap_file_path = getenv(ENV_LEAP_FILE_PATH)) == NULL ){
                /* 環境変数取得エラー */
                return(-11);
        }

	/****************************************************************
	 * 衛星時刻校正表ファイルパスを設定済みか確認
	 ****************************************************************/
	ret = timeCalFileSetFlagCheck(0);
	if( ret == 0 ){
		/* ファイル設定 */
		ret = setTimeCalFile(timecal_file_path);
		/* 戻り値設定 */
		if( ret != RET_NORMAL ){
			return( -11 );
		}
		ret = timeCalFileSetFlagCheck(1);
	}

	/****************************************************************
	 * うるう秒ファイルパスを設定済みか確認 *
	 ****************************************************************/
        ret = leapSecFileSetFlagCheck(0);
        if( ret == 0 ){
                ret = setLeapSecFile(leap_file_path);
                /* 戻り値設定 */
                if( ret != RET_NORMAL ){
                        return( -11 );
                }
		ret = leapSecFileSetFlagCheck(1);
        }

	/****************************************************************
	 * ETI拡張部の上位16ビットを0埋め、ETIフラグ設定してeti2es関数用のパラメータ作成
	 ****************************************************************/
	extVal = eti_ext;
	extVal = extVal & extZeroSet;
	/* ETIフラグ設定 */
	if( (eti_ext & extFlgMask) != 0 ){
		extVal = extVal | extFlgSet;
	}

	/****************************************************************
	 * eti2es関数呼び出し
	 ****************************************************************/
	ret = eti2es(extVal, eti_base, elapsed_seconds);

	/* 戻り値判定 */
	if( ret == RET_NORMAL ||
		ret == RET_BEFORE_FIRST_RECORD ||
		ret == RET_AFTER_LAST_RECORD ||
		ret == RET_BETWEEN_DISCONT_RECORDS ||
		ret == RET_INAPPROPRIATE_PART ){
		f_ret = 0;
	}else if( ret == RET_PARAM_ERR ){
		f_ret = -1;
	}else if( ret == RET_FILE_UNSET_ERR || ret == RET_FILE_OPEN_ERR ){
		f_ret = -11;
	}else if( ret == RET_FILE_READ_ERR ){
		f_ret = -12;
	}else{
		f_ret = -99;
	}

	return( f_ret );

}
