/*******************************************************************

衛星時刻→ＵＴＣ(ASCII)変換処理	  種別：sub

   Program-Name  : TT2ACSUT

   Calling Sequence :

      int  TT2ACSUT( int Kind, double elapsed_seconds, char *utc );

      In : int Kind : 1 : YYYYMMDDhhmmss(msmsmsususus)
                      2 : YYYY0DDDhhmmss(msmsmsususus)
      In : double elapsed_seconds : TotalTime (sec)
      Out : char utc : 20+1bytes

   Return :
		0			：正常終了
		-1			：入力パラメータチェックエラー
		-11			：ファイルオープンエラー
		-12			：ファイルリードエラー

   Date : 2013/06/01 後方互換関数として新規作成

*******************************************************************/


#include	<stdio.h>
#include	<stdlib.h>
#include	"TiTm_type.h"


int  TT2ASCUT( int Kind, double elapsed_seconds, char *utc ) {

	/****************************************************************/
	/* 領域定義														*/
	/****************************************************************/
	char *leap_file_path;	/* うるう秒ファイルパス */
	int ret, f_ret;

	/*
	 * うるう秒のファイルパス確認
	 * うるう秒ファイルは、es2utc関数内で毎回読み込んでいるので更新確認は行わない
	 */
	if((leap_file_path = getenv(ENV_LEAP_FILE_PATH)) == NULL ){
		/* 環境変数取得エラー */
		return(-11);
	}

	/* うるう秒ファイルパスを設定済みか確認 */
	ret = leapSecFileSetFlagCheck(0);
	if( ret == 0 ){
		ret = setLeapSecFile(leap_file_path);
		/* 戻り値設定 */
		if( ret != RET_NORMAL ){
			return( -11 );
		}
		ret = leapSecFileSetFlagCheck(1);
	}

	/*
	 * es2utc()呼び出し
	 */
	ret = es2utc( Kind, elapsed_seconds, utc );

	/* 戻り値設定 */
	if( ret == RET_NORMAL ){
		f_ret = 0;
	}else if( ret == RET_PARAM_ERR ){
		f_ret = -1;
	}else if(ret == RET_FILE_UNSET_ERR || ret == RET_FILE_OPEN_ERR ){
		f_ret = -11;
	}else if(ret == RET_FILE_READ_ERR ){
		f_ret = -12;
	}else{
		/* 到達不可 */
		f_ret = -99;
	}

	return(f_ret);

}
