/**********************************************************
 *
 *          * SATELLITE TRANSMIT SYSTEM *
 *
 *      P.NAME      : hexasc
 *
 *      FUNCTION    : HEX(BCD) TO ASCII-CODE
 *
 *      CALLING SEQUENCE
 *          hexasc( hex , asc , leng , ispos , iepos )
 *
 *      RETURN VALUE
 *          int     :  0 normal end
 *                  : -1 error end
 *
 *      ARGUMENT
 *          hex     : (IN) (*char) hex(bcd)-code start pointer
 *          asc     : (IN) (*char) ascii-code    start pointer
 *          leng    : (IN) (*int)  change hex-code length
 *          ispos   : (IN) (*int)  input  data point(1<-4bit)
 *          iepos   : (IN) (*int)  output data point(1<-byte)
 *
 *      DATE        : 90.10.04 S.OGATA
 *                    2012/11/15  Ver2.0 y.yoneda  インデントの調整
 *					  2012/12/06  Ver2.0 y.yoneda  Ver2.0対応
 *
 *      note        : a-f : "oomoji" code desu. (A-F)
 *********************************************************/
#include	<inttypes.h>
#include        "Com_type.h"
#include        "Com_bcd.h"
 
static uint8_t     htoa (int32_t dt);	/* Chg Ver2.0 */

int com_hexasc_ (const uint8_t *hex, char *asc, int *leng, int *ispos, int *iepos)
{
/* Del Ver2.0
 uint8_t        hex[];
 char           asc[];
 int            *leng, *ispos, *iepos; 
*/

//    union uni       un;	/* Del Ver2.0 */
	unsigned char			wk;		/* Add Ver2.0 */
    int             start_point, end_point, asc_point, i;
//    int			    order;	/* Del Ver2.0 */

    /* ERROR CHECK */
    if (*leng < 1 || *ispos < 1 || *iepos < 1) {
		return (-1);
    }
    /* DATA SET */
    asc_point = *iepos - 1 + *leng - 1;
    start_point = *ispos - 1;
    end_point = *leng / 2 + start_point - 1;
    /* 4BIT DATA */
    if (*leng % 2 != 0) {
/* Chg Ver2.0 Start */
    	wk = (unsigned char)hex[end_point + 1];
    	asc[asc_point--] = (char)htoa((int32_t)(wk/16));
/*
		un.bit = hex[end_point + 1];
        order = 1;
        if(*((char *) &order)){
	  		asc[asc_point--] = htoa (un.st.bit_low);
		} else {
	  		asc[asc_point--] = htoa (un.st.bit_high);
		}
*/
/* Chg Ver2.0  End  */
    }
    /* LENGTH = 1 : END */
    if (end_point < 0) {
		return (0);
    }
    /* CHANGE DATA */
    for (i = end_point; i >= start_point; i--) {
/* Chg Ver2.0 Start */
    	wk = (char)hex[i];
    	asc[asc_point--] = (char)htoa((int32_t)(wk%16));
    	asc[asc_point--] = (char)htoa((int32_t)(wk/16));
/*
		un.bit = hex[i];
        order = 1;
        if(*((char *) &order)){
	  		asc[asc_point--] = htoa (un.st.bit_high);
	  		asc[asc_point--] = htoa (un.st.bit_low);
		} else {
	  		asc[asc_point--] = htoa (un.st.bit_low);
	  		asc[asc_point--] = htoa (un.st.bit_high);
		}
*/
/* Chg Ver2.0  End  */
    }
    return (0);
}
/* BINARY -> ASCII-CODE */
static uint8_t
htoa (dt)
    int32_t             dt;
{
    if (dt < 10) {
		return (dt + '0');
    }
    return (dt - 10 + 'A');
}
