/*******************************************************************

トータル時刻ＵＴ変換処理(初期処理)	                  種別：sub

	(1)処理概要
		うるう秒が挿入される時刻を
		２０００年１月１日０時０分０秒からのトータル秒に
		変換したテーブルをメモリ上に展開する。

	(2)呼出形式
		Ir = UtTt_Init()

	(3)環境変数
		・TM_LEAP_FPATH
         うるう秒テーブルのファイル名をフルパスで指定する。

	(4)パラメタ説明
		・復帰値(出力／int)
			0   ： 正常終了
			-1  ： 異常終了

	(5) 作成日 2004/07/21
                   2011/02/17  共通化
            	   2012/11/15  y.yoneda  インデントの調整
            	   2012/11/16  y.yoneda  1.うるう年チェック方法厳密化
            	                         2.静解析結果の修正
            	   2013/08/   Ver3.0.0 fips    エラーメッセージ出力追加
            	   2014/09/01 Ver3.0.2 fae     変数初期化

	(6) 作成者 山口 喬

*******************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<sys/fcntl.h>
#include	<errno.h>
#include	<string.h>
#include	"TimeCal_type.h"	/* Chg Ver2.0 */
#include	"SATCA_com.h"		/* Add Ver2.0 */
#include	"UtTt.h"


int UtTt_Init( UtTt *uttt  ) {

	/*領域定義*/

	FILE *fp;				/* ファイルポインタ */
	char fname[FILE_PATH_MAX_LENGTH+1];	/* Chg Ver2.0 */
	char recoad[50];		/* ファイルから読込んだ１レコードを入れる */
	char *read_item;		/* 項目抜出し作業用 */
	char *cp_save;			/* 項目抜出し作業用 */
	int item_cnt;			/* 抜出す項目数を数える */
	int i;

	int total_year;  		/* トータル年の計算に使用する */
	int total_month = 0; 	/* トータル月の計算に使用する */	/* Chg Ver2.0 */
	int total_day = 0;		/* トータル日の計算に使用する */	/* Chg Ver2.0 */
	int total_hour = 0;		/* トータル時の計算に使用する */	/* Chg Ver2.0 */
	int total_min = 0;		/* トータル分の計算に使用する */	/* Chg Ver2.0 */
	int total_sec = 0;		/* トータル秒の計算に使用する */	/* Chg Ver2.0 */
	double total_msec = 0;	/* トータルミリ秒の計算に使用する *//* Chg Ver2.0 */
	int rtn;				/* Add Ver2.0 */

	char errMsg[EMGS_MSG_LENGTH];	/* Add Ver3.0.0 エラーメッセージ */
	int recnum_for_msg = 0;		/* Add Ver3.0.0 エラーメッセージ用 */


	/******************************************************************/
	/***              トータル秒版うるう秒テーブル作成              ***/
	/***        最初の呼び出しの場合のみテーブル展開を行う          ***/
	/******************************************************************/

	/*--------------------------------------------------------------*/
	/* 最初の呼び出し判定						*/
	/*--------------------------------------------------------------*/

	/* Add&Chg Ver2.0 start */
	if( uttt == NULL ) {
		return(RET_PARAM_ERR);
	}
#ifdef DBG_TITM
	printf( "uttt->UtTt_initial[%d]\n", uttt->UtTt_initial );
#endif

	memset(fname, 0, sizeof(fname));	/* Add Ver3.0.2 */
	rtn = filepath_mng(LEAP_FILE_PATH_GET, fname);
	if( rtn == RET_FILE_UNSET_ERR ) {
#ifdef DBG_TITM
		printf( "file path unset error :LEAP_FILE_PATH_GET\n" );
#endif
		return(RET_FILE_UNSET_ERR);
	}
	else if( rtn != RET_FILE_INIT_READ && uttt->UtTt_initial == 12345678 ) {
	/* Add&Chg Ver2.0 end */
#ifdef DBG_TITM
		printf( "exit uttt->UtTt_initial[%d]\n", uttt->UtTt_initial );
#endif
		return(RET_NORMAL);		/* Chg Ver2.0 */
	}

/* Del Ver2.0 Start */
	/*--------------------------------------------------------------*/
	/* 環境変数からファイル名を抽出					*/
	/*--------------------------------------------------------------*/

//	if( fname = getenv( "TM_LEAP_FPATH" ) );
//	else {
//#ifdef DBG_TITM
//		printf( "environment error :TM_LEAP_FPATH\n" );
//#endif
//		return(-11);
//	}
/* Del Ver2.0  End  */

	/*--------------------------------------------------------------*/
	/* うるう秒テーブルファイルをオープンする。						*/
	/*--------------------------------------------------------------*/
	if((fp = fopen(fname,"r")) == NULL){
		/* 異常終了 */
#ifdef DBG_TITM
		printf( "UtTt_Init[%d] Lepasec.dat File Open Error!! [%s]\n", __LINE__ , fname );
#endif
		return(RET_FILE_OPEN_ERR);		/* Chg Ver2.0 */
	}


	/*--------------------------------------------------------------*/
	/* うるう秒テーブルファイルを読み込み				*/
	/*--------------------------------------------------------------*/
	uttt->UtTt_uruu_rdcnt = 0;
	while(fgets(recoad, 50, fp)){
		uttt->UtTt_uruu_tbl[uttt->UtTt_uruu_rdcnt].Total_sec = 0.0;
		uttt->UtTt_uruu_tbl[uttt->UtTt_uruu_rdcnt].uruu_sec = 0;

		recnum_for_msg++;
		/*--------------------------------------------------------------*/
		/* トータル秒計算 						*/
		/* うるう秒が挿入される時刻と挿入される秒数を抜出す。		*/
		/* 空白区切りで1項目(YYYY)を抜出す				*/
		/*--------------------------------------------------------------*/
#if 0
		read_item = strtok(recoad, " \n");
#else
		read_item = (char *)strtok_r(recoad, " \n", &cp_save);
#endif

		/* 抜出した年をint型に変換する	*/
		total_year = atoi(read_item);
		/* 2000年のレコードか判定する。*/
		if(total_year  < 2000){
			/* 2000年より前の年代は処理しない。*/
			continue;
		}

		item_cnt = 2;
		while((read_item = (char *)strtok_r(NULL, " \n", &cp_save)) != NULL){
			if(item_cnt == 2){
				/* 2項目のMMを抜出す。			*/
				/* 抜出した月をint型に変換する		*/
				total_month = atoi(read_item);

			}else if(item_cnt == 3){
				/* 3項目のDDを抜出す。			*/
				/* 抜出した日をint型に変換する		*/
				total_day = atoi(read_item);

			}else if(item_cnt == 4){
				/* 4項目のHHを抜出す。			*/
				/* 抜出した時をint型に変換する		*/
				total_hour = atoi(read_item);

			}else if(item_cnt == 5){
				/* 5項目のmmを抜出す。			*/
				/* 抜出した分をint型に変換する		*/
				total_min = atoi(read_item);

			}else if(item_cnt == 6){
				/* 6項目のssを抜出す。			*/
				/* 抜出した秒をint型に変換する		*/
				total_sec = atoi(read_item);

			}else if(item_cnt == 7){
				/* 7項目のmsを抜出す。			*/
				/* 抜出したミリ秒 をdouble型に変換する*/
				total_msec = atof(read_item);

			}else if(item_cnt == 8){
				/* 8項目のSを抜出す。			*/
				/* 抜出した挿入される秒数をint型に変換する*/
				uttt->UtTt_uruu_tbl[uttt->UtTt_uruu_rdcnt].uruu_sec = atoi(read_item);	/* Chg Ver2.0 */
			}
			item_cnt++;
		} /******* while((read_item = strtok(NULL, " \n")) != NULL) */
		if( item_cnt < 9 ) {			/* Add Ver3.0.0 */

			sprintf(errMsg, EMSG_FILEREAD_ERR_FMT1, fname, recnum_for_msg, item_cnt, EMSG_FILEREAD_ERR_REASON1);
			rtn = outputMessage(errMsg);
			fclose(fp);
			if(rtn != RET_NORMAL){
				return(rtn);
			}

			return(RET_FILE_READ_ERR);				/* Add Ver2.0 */
		}

		/*YYYYから2000を引きトータル年を計算する。*/
		total_year -= 2000;

		/*トータル年からトータル日に変換する。*/
		for(i = 0; i < total_year; i++){
			if( (i % 4) == 0 && ((i % 100) != 0 || (i % 400) == 0) ){		/* Chg Ver2.0 うるう年の判定 */
				/*トータル日に366日を加算*/
				total_day += 366;
			}else{
				/*トータル日に365日を加算*/
				total_day += 365;
			}
		}

		/*トータル月からトータル日に変換する。*/
		for(i = 1; i < total_month; i++){
			if(i == 1 || i == 3 || i == 5 || i == 7 || i == 8 || i == 10 || i == 12){
				/*トータル日に31を加算*/
				total_day += 31;
			}else if(i == 4 || i == 6|| i == 9 || i == 11){
				/*トータル日に30を加算*/
				total_day += 30;
			}else{
				if((total_year%4) == 0 && ((total_year % 100) != 0 || (total_year % 400) == 0)){	/* Chg Ver2.0 */
					/*トータル日に29を加算*/
					total_day += 29;
				}else{
					/*トータル日に28を加算*/
					total_day += 28;
				}
			}
		} /* for */

		/*DDから01を引き、トータル日に加算する。*/
		total_day -= 1;

		/*トータル秒計算*/
		uttt->UtTt_uruu_tbl[uttt->UtTt_uruu_rdcnt].Total_sec
			= (((total_day * 24) + total_hour) * 60 + total_min ) * 60 + total_sec + total_msec;

		/*レコード数カウンタ計算*/
		uttt->UtTt_uruu_rdcnt++;

	} /******** while(fgets(recoad, 50, fp)) */

	fclose( fp );

	if( uttt->UtTt_uruu_rdcnt == 0 ) {			/* Add Ver2.0 */

		/* Add Ver3.0.0 エラーメッセージ出力 */
		sprintf(errMsg, EMSG_FILEREAD_ERR_FMT3, fname, EMSG_FILEREAD_ERR_REASON4);
		rtn = outputMessage(errMsg);
		if(rtn != RET_NORMAL){
			return(rtn);
		}

		return(RET_FILE_READ_ERR);				/* Add Ver2.0 */
	}											/* Add Ver2.0 */

	/**********************/
	/**  復帰情報を返す  **/
	/**********************/
	/* 正常終了 */
#ifdef DBG_TITM
	printf( "[%s:%d]  UtTt_Init success [%d]\n", __FILE__ , __LINE__, uttt->UtTt_uruu_rdcnt ) ;
#endif
	uttt->UtTt_initial = 12345678;

	return(RET_NORMAL);		/* Chg Ver2.0 */

}
