/*****************************************************
 *
 *  LEVEL0 --- Time Convert function
 *
 *   2010.02.08
 *   2012.11.21 Ver2.0 y.yoneda 関数名およびパラメータの変更
 *   2013.08.   Ver3.0.0 fips エラーメッセージ出力ファイルパス設定関数追加
 *   2015.02.19 Ver3.1.0 fae  C++からの呼び出し対応
 *   2018.12.07 Ver3.3.0 jex  フレーム方式対応
 *
 *****************************************************/
#ifndef	TITM_TYPE_HEADER
#define	TITM_TYPE_HEADER

#include        <inttypes.h>
#include        "TimeCal_rtn.h"	/* Add Ver2.0 */

/* Add Ver3.1 str */
#ifdef __cplusplus
extern "C" {
#endif
/* Add Ver3.1 end */

int filepath_mng( int flg, char *filepath );
int setTimeCalFile( const char *filepath );
int setLeapSecFile( const char *filepath );
int setErrorMsgFile( const char *filepath );	/* ver3.0.0 add */

/** Convert Sat-Time(TT) to UT time
 * param[in]  Kind       Date-Time TYPE (1:YYYYMMDDhhmmssmsmsmsususus
										 2:YYYY0DDDhhmmssmsmsmsususus)
 * param[in]  elapsed_seconds   Sat-Time(TT)
 * param[out] *utc UT time converted from the Sat-Time(TT)
 * return     0          Succeed.
 * return    <0          Failed.
 */
int  es2utc( int Kind, double elapsed_seconds, char *utc );
int  es2utcbcd( int Kind, double elapsed_seconds, uint8_t *utc_bcd );


/* Convert UT time to Sat-Time(TT)
 * param[in]  Kind      Date-Time TYPE (1:YYYYMMDDhhmmssmsmsmsususus
										2:YYYY0DDDhhmmssmsmsmsususus)
 * param[in]  utc UT time
 * param[out] *elapsed_seconds Sat-Time(TT) converted from the UT time
 * return     0         Succeed.
 * return    <0         Failed.
 */
int  utc2es( int Kind,  const char *utc,  double *elapsed_seconds );
int  utcbcd2es( int Kind,  const uint8_t utc_bcd[10],  double *elapsed_seconds );


/** Perform time conversion from TI to Sat-Time(TT).
 * param[in]  estimated_utc Rough estimate of Date-Time to be converted
 *                       ( used to resolve role over of TI clock).
 *                       ( char Date_Time[14] : "YYYYMMDDhhmmss" )
 * param[in]  eti_base        	Low resolution TI clock in the unit of 1/32 sec
 * param[out] *elapsed_seconds 	Sat-Time(TT) converted from the TI.
 * param[out] *eti_ext      	ExtendedTI.
 * return      0        Succeed.
 * return     <0        Failed.
 */
#define ti2es(eutc, tib, es, ...)	func_ti2es(eutc, tib, es, ##__VA_ARGS__, UINT32_MAX)
int  func_ti2es( const char *estimated_utc, uint32_t eti_base, double *elapsed_seconds, ... );

/* Add Ver3.3.0 str */
/** Perform time conversion from TI to Sat-Time(TT).
 * param[in]  estimated_utc Rough estimate of Date-Time to be converted
 *                       ( used to resolve role over of TI clock).
 *                       ( char Date_Time[14] : "YYYYMMDDhhmmss" )
 * param[in]  eti_base        	Low resolution TI clock in the unit of 1/32 sec
 * param[out] *elapsed_seconds 	Sat-Time(TT) converted from the TI.
 * param[out] *eti_ext      	ExtendedTI.
 * return      0        Succeed.
 * return     <0        Failed.
 */
#define tc2es(eutc, tib, es, ...)	func_tc2es(eutc, tib, es, ##__VA_ARGS__, UINT32_MAX)
int  func_tc2es( const char *estimated_utc, uint64_t eti_base, double *elapsed_seconds, ... );
/* Add Ver3.3.0 end */
	
/** Perform time conversion from ETI+TI to Sat-Time(TT).
 * param[in]  eti_ext 			ExtendedTI
 * param[in]  eti_base        	Low resolution TI clock in the unit of 1/32 sec
 * param[out] *elapsed_seconds 	Sat-Time(TT) converted from the TI.
 * return      0        Succeed.
 * return     <0        Failed.
 */
int  eti2es( uint32_t eti_ext, uint32_t eti_base, double *elapsed_seconds );

/* Add Ver3.3.0 str */
/** Perform time conversion from ETI+TI to Sat-Time(TT).
 * param[in]  eti_ext 			ExtendedTI
 * param[in]  eti_base        	Low resolution TI clock in the unit of 1/32 sec
 * param[out] *elapsed_seconds 	Sat-Time(TT) converted from the TI.
 * return      0        Succeed.
 * return     <0        Failed.
 */
int  etc2es( uint32_t eti_ext, uint64_t eti_base, double *elapsed_seconds );
/* Add Ver3.3.0 end */

/** Perform time conversion from Sat-Time(TT) to TI.
 * param[in]  elapsed_seconds	Sat-Time(TT)
 * param[out] *eti_base      	TI converted from the Sat-Time(TT)
 * param[out] *extrapolation 	ETI converted from the Sat-Time(TT)
 * return      0       Succeed.
 * return     <0       Failed.
 */
#define es2eti(es, eti_base, ...)	func_es2eti(es, eti_base, __VA_ARGS__, UINT32_MAX)
#define es2ceti(es, eti_base, ...)	func_es2ceti(es, eti_base, __VA_ARGS__, UINT32_MAX)
int  func_es2eti( double elapsed_seconds,  uint32_t *eti_base, ... );
int  func_es2ceti( double elapsed_seconds,  double *eti_base, ... );

/* Add Ver3.3.0 str */
/** Perform time conversion from Sat-Time(TT) to TI.
 * param[in]  elapsed_seconds	Sat-Time(TT)
 * param[out] *eti_base      	TI converted from the Sat-Time(TT)
 * param[out] *extrapolation 	ETI converted from the Sat-Time(TT)
 * return      0       Succeed.
 * return     <0       Failed.
 */
#define es2etc(es, eti_base, ...)	func_es2etc(es, eti_base, __VA_ARGS__, UINT32_MAX)
#define es2cetc(es, eti_base, ...)	func_es2cetc(es, eti_base, __VA_ARGS__, UINT32_MAX)
int  func_es2etc( double elapsed_seconds,  uint64_t *eti_base, ... );
int  func_es2cetc( double elapsed_seconds,  double *eti_base, ... );
/* Add Ver3.3.0 end */
	
/* Add Ver3.3.0 str */
/** Perform recovery of the significant octets of the Message Time.
 * param[in]  msg_time          message time (time code field of SMCP message).
 * param[in]  pkt_time          packet time.
 * param[in]  num_missing_bits  number of missing bits.
 * return     full bits of the Mesage Time.
 */
uint64_t recover_missing_bits(uint64_t msg_time, uint32_t pkt_time, unsigned int num_missing_bits);
/* Add Ver3.3.0 end */

/* Add Ver3.1 str */
#ifdef __cplusplus
}
#endif
/* Add Ver3.1 end */

#endif	/*TITM_TYPE_HEADER*/
/*----------------------------------------------------------------*/
