/****************************************/
/*     TimeCal_rtn.h               	    */
/*                                 	    */
/*  DATE 12.12.11 Ver2.0                */
/*                                      */
/****************************************/
#ifndef	TIMECAL_RTN_HEADER
#define	TIMECAL_RTN_HEADER

/******************************************/
/*** 戻り値定義情報						***/
/******************************************/
#define	RET_NORMAL					0		/* 正常終了 						*/
#define	RET_BEFORE_FIRST_RECORD		1		/* 校正結果が最初のレコード以前 	*/
#define	RET_AFTER_LAST_RECORD		2		/* 校正結果が最後のレコード以降 	*/
#define	RET_BETWEEN_DISCONT_RECORDS	3		/* 校正結果がTI不連続区間に該当 	*/
#define	RET_BETWEEN_DISCONT_RECORDS_WITH_ROLLOVER	4
											/* 校正結果がTI不連続区間に該当 & ロールオーバー対応 */
#define	RET_INAPPROPRIATE_PART		5		/* 指定etiの校正結果が別の連続区間にある */
#define	RET_PARAM_ERR				-1		/* 入力パラメータチェックエラー 	*/
#define	RET_FILE_NOTFOUND_ERR		-2		/* 指定ファイルなし 				*/
#define	RET_FILE_UNSET_ERR			-11		/* ファイルパス未設定 				*/
#define	RET_FILE_OPEN_ERR			-12		/* ファイルオープンエラー 			*/
#define	RET_FILE_READ_ERR			-13		/* ファイルリードエラー 			*/
#define	RET_EXT_NOTFOUND_ERR		-21		/* 指定eti拡張部なし 				*/
#define	RET_DISCONTINUITY_ERR		-22		/* TI不連続区間のため算出不可 		*/
#define	RET_OUT_OF_RANGE_ERR		-23		/* 指定範囲に該当TIなし 			*/
#define	RET_RUNOUT_OF_EXT_ERR		-24		/* ETI拡張部の更新でキャリーオーバーした */
#define	RET_CALC_RESULT_ERR			-98		/* 算出結果異常（マイナス値またはMAX値オーバー） */
#define	RET_CALC_ERR				-99		/* 算出不可 						*/


#endif	/* TIMECAL_RTN_HEADER */

