/*****************************************************
 *
 *  LEVEL0 --- Time Convert function
 *
 *   2013.06.01 Ver2.1.0 fips 後方互換関数用
 *   2015.02.16 Ver3.1.0 fae  プロトタイプ宣言追加
 *                            C++からの呼び出し対応
 *
 *****************************************************/
#ifndef	TITM_TYPE_HEADER_OLD
#define	TITM_TYPE_HEADER_OLD

#include        <inttypes.h>
#include        "TimeCal_type.h"
#include        "TimeCal_rtn.h"

/* Add Ver3.1 str */
#ifdef __cplusplus
extern "C" {
#endif

/* Add Ver3.1 end */
/* TI2TIME()からti2es()への検索期間(日) */
#define TI2TIME_SRCH_TERM 100
/* TIME2TI()からes2eti()への不連続時の処理基準方向 1:過去 2:未来 */
#define TIME2TI_SRCH_DIR 1

/* 環境変数 */
#define ENV_LEAP_FILE_PATH "TM_LEAP_FPATH"
#define ENV_TIMECAL_FILE_PATH "TM_STD_FPATH"

/** Convert Sat-Time(TT) to UT time
 * param[in]  Kind       Date-Time TYPE (1:YYYYMMDDhhmmssmsmsmsususus
										 2:YYYY0DDDhhmmssmsmsmsususus)
 * param[in]  Sat_Time   Sat-Time(TT)
 * param[out] *Date_Time(Bcd_Date) UT time converted from the Sat-Time(TT)
 * return     0          Succeed.
 * return    <0          Failed.
 */
int  TT2ASCUT( int Kind, double Sat_Time, char *Date_Time );
int  TT2BCDUT( int Kind, double Sat_Time, uint8_t *Bcd_Date );


/* Convert UT time to Sat-Time(TT)
 * param[in]  Kind      Date-Time TYPE (1:YYYYMMDDhhmmssmsmsmsususus
										2:YYYY0DDDhhmmssmsmsmsususus)
 * param[in]  Date_Time(Bcd_Date) UT time
 * param[out] *Sat_Time Sat-Time(TT) converted from the UT time
 * return     0         Succeed.
 * return    <0         Failed.
 */
int  ASCUT2TT( int Kind,  const char *Date_Time,  double *Sat_Time );
int  BCDUT2TT( int Kind,  const uint8_t Bcd_Date[10],  double *Sat_Time );


/** Perform time conversion from TI to Sat-Time(TT).
 * param[in]  Date_Time Rough estimate of Date-Time to be converted
 *                       ( used to resolve role over of TI clock).
 *                       ( char Date_Time[14] : "YYYYMMDDhhmmss" )
 * param[in]  Ti        	Low resolution TI clock in the unit of 1/32 sec
 * param[out] *Sat_Time 	Sat-Time(TT) converted from the TI.
 * param[out] *Ext      	ExtendedTI.
 * return      0        Succeed.
 * return     <0        Failed.
 */
int  Ti2Time( const char *Date_Time, uint32_t Ti, double *Sat_Time, uint16_t *Ext );

/** Perform time conversion from ETI+TI to Sat-Time(TT).
 * param[in]  Ext 			ExtendedTI
 * param[in]  Ti        	Low resolution TI clock in the unit of 1/32 sec
 * param[out] *Sat_Time 	Sat-Time(TT) converted from the TI.
 * return      0        Succeed.
 * return     <0        Failed.
 */
int  Eti2Time( uint16_t Ext, uint32_t Ti, double *Sat_Time );

/** Perform time conversion from Sat-Time(TT) to TI.
 * param[in]  Sat_Time	Sat-Time(TT)
 * param[out] *Ti      	TI converted from the Sat-Time(TT)
 * param[out] *Ext 	ETI converted from the Sat-Time(TT)
 * return      0       Succeed.
 * return     <0       Failed.
 */
int  Time2Ti( double Sat_Time,  uint32_t *Ti, uint16_t *Ext );

int leapSecFileSetFlagCheck( int ); /* Add Ver3.1 */
int timeCalFileSetFlagCheck( int ); /* Add Ver3.1 */

/* Add Ver3.1 str */
#ifdef __cplusplus
}
#endif

/* Add Ver3.1 end */
#endif	/*TITM_TYPE_HEADER_OLD*/
/*----------------------------------------------------------------*/
