/********************************************/
/*     SATCA_com.h                 	        */
/*                                 	        */
/*  DATE 04.07.21                  	        */
/*       11.02.17 共通化                 	*/
/*       12.11.21 Ver2.0                    */
/*       13.08.XX Ver3.0.0                  */
/*       15.02.13 Ver3.1.0                  */
/*       15.10.19 Ver3.1.1                  */
/*       18.12.05 Ver3.3.0 フレーム方式対応 */
/********************************************/
#ifndef	SATCA_COM_HEADER
#define	SATCA_COM_HEADER

#include	<time.h>
#include    "TimeCal_rtn.h"	/* Add Ver2.0 */

/******************************************/
/*** ローカル戻り値定義情報	(Add Ver2.0)***/
/******************************************/
#define	RET_FILE_INIT_READ			100		/* ファイル初期読み込み要求あり */
#define	RET_NORMAL_BREAK			200		/* 強制正常終了 */

/******************************************/
/*** 定義情報					        ***/
/******************************************/
#define TBASE_REC_LENG 1023		/* Chg Ver3.0.0 200 -> 1023 */
#define TBASE_DEF_REC_LENG 204	/* Add Ver3.0.0 レコード長無指定の場合の値 *//* Chg Ver3.1.0 200 -> 204 */
#define BEFORE_CNT 50*24*60*60/32	/* Chg Ver2.0 *//* Chg Ver3.1.1 100*5*3 -> 50*24*60*60/32 */
#define AFTER_CNT  50*24*60*60/32	/* Chg Ver3.1.1 10*5*3 -> 50*24*60*60/32 */
#define SATCA_cnvtbl_max BEFORE_CNT+AFTER_CNT+10
#define TMCAL_FILE_CHK_SEC	1*60	/* Add Ver3.1.1 衛星時刻校正表監視間隔 */

/* Add Ver2.0 */
#define TIME_STR_KIND_MMDD	1
#define TIME_STR_KIND_0DDD	2
#define DATA_TOP_RECORD		2				/* 衛星時刻校正表のデータレコード先頭位置 */
#define TMCAL_FILE_PATH_SET	1
#define TMCAL_FILE_PATH_GET	2
#define LEAP_FILE_PATH_SET	3
#define LEAP_FILE_PATH_GET	4
#define ERROR_FILE_PATH_SET	5				/* ver3.0.0 add エラーメッセージ出力ファイル */
#define ERROR_FILE_PATH_GET	6				/* ver3.0.0 add エラーメッセージ出力ファイル */
#define FILE_PATH_MAX_LENGTH	127
#define FILE_INIT_READ		RET_FILE_INIT_READ		/* ファイル初期読み込み要 */
#define DAY_SEC				(24*60*60)				/* 1日の秒数 */
#define SEARCH_DAY_COUNT_HALF	50					/* 一回の検索で対象とする日数の半分 */
#define ROLL_OVER_PLUS		1
#define ROLL_OVER_MINUS		2
#define USE_NEXT_RATE		1
#define OVERLAP_READ_COUNT	5
#define ETI_FLAG_PATTERN		0x80000000	/* ETIフラグ位置 			*/
#define ETI_FLAG_MASK_PATTERN	0x7FFFFFFF	/* ETIフラグマスクパターン 	*/

#define TITM_INIT_KIND_SAT_1	1			/* 探索方向なし または 探索方向：過去および未来 */
//#define TITM_INIT_KIND_SAT_2	2			/* 探索方向：過去 */
//#define TITM_INIT_KIND_SAT_3	3			/* 探索方向：未来 */
#define TITM_INIT_KIND_ETI		4

#define FLAG_ON				1
#define FLAG_OFF			0

#define DATA_UPDATE		1					/* 情報の更新を行った */
#define NOT_UPDATE		2					/* 算出できたが情報は更新しない */
#define CALC_BREAK		3					/* 算出結果不正 */

/******************************************/
/*** 基準時刻テーブル			        ***/
/******************************************/
typedef struct {
	double	tpktTI;		 	 /* TimePacketTI 			*/ /* ETI基本部      */
   	double	tpktTI_SATsec;   /* TimePacketTIの衛星時刻 	*/ /* UTC            */
   	double	tpktTI_dT;       /* TimePacketTIのベース時間*/ /* レート/10の6乗 */
   	double	tpktETITI;	 	 /* ETI+TI		        	*/ /* ETI            */
   	uint32_t	ETI;	 	 /* ETI			        	*//* Chg Ver2.0 */ /* ETI拡張部 */
   	char	quality_flag[2]; /* クオリティーフラグ		*/
// 	char	chij_time[21]; 	 /* 地上時刻 				*//* Del Ver3.1.1 (not used) */
} SATCA_cnv;

/************************************/
/* 変換（初期処理）のパラメータ     */
/************************************/
typedef struct {
	char	fname[128];		/* フルパスのファイル名 	*/
	double	SATsec;			/* 衛星時刻 				*/
	double	ETI_TI;			/* 衛星時刻 				*/
//	int		TPktTI_bit;		/* TimePacketTIのビット数   *//* Del Ver2.0 */
//	int		TPktTI_dT2n;	/* TimePacketTIのベース乗数 *//* Del Ver2.0 */
//	double	TPktTI_dT;		/* TimePacketTIのベース時間 *//* Del Ver2.0 */
	int		SHeadTI_dT2n;	/* 2ndHeaderTIのベース乗数  */
	double	SHeadTI_dT;		/* 2ndHeaderTIのベース時間  */
	double	xffmax;			/* TimePacketTIのMAX値      */
	double	xffhalf;		/* TimePacketTIのMAX値の半分*/
} SATCA_INI;

/******************************************/
/*** 時刻校正用変換テーブル				***/
/******************************************/
typedef struct {

	/******************************************/
	/*** 時刻付け用変換テーブル      	***/
	/******************************************/

	int SATCA_initial;     		/* 初期化フラグ */

	int SATCA_cnv_rdcnt;     	/* レコード数 */
	int SATCA_cnv_endflg;		/* 1:変換テーブルの最後のレコードをメモリに展開した。	*/
								/* 0:変換テーブルの最後のレコードをメモリに展開していない。	*/
   	int	SATCA_cnv_topflg;	 	/* ファイルポジション 1:先頭から読み込み   	*/
	int	SATCA_top_rec;			/* 変換テーブルの先頭レコードが衛星時刻校正表の何レコードに該当するか *//* Add Ver2.0 */
   	int	SATCA_cnv_errflg;	 	/* 1:エラー（E)あり   	*/
	time_t SATCA_cnv_getTime;   /* 処理時刻保存 */

	/******************************************/
	/*** 時刻付け用変換テーブル      	***/
	/******************************************/
	SATCA_cnv SATCA_cnv_tbl[SATCA_cnvtbl_max];	/* 基準時刻テーブル設定領域 */
	 /* 110日分 * 1日5パス * 1パス3点 + 10 = 1660 */

	int SATCA_cnv_rdlen;     	/* レコード長 *//* Add Ver3.0.0 */

/************************************/
/* 変換（初期処理）のパラメータ     */
/************************************/
	SATCA_INI	SATCA_Init;

} TiTm_tbl;


/************************************/
/* 変換（初期処理）のパラメータ     */
/************************************/
typedef struct {
//        int read_max;           /* 変換テーブルをメモリに設定したレコードの最大位置 */	/* Del Ver2.0 */

//        double pTi;             /* 時刻付計算用の変数。TIを入れる。     */	/* Del Ver2.0 */
        double Satt;            /* 時刻付計算用の変数。衛星時刻を入れる */
//        double Td;              /* 時刻付計算用の変数。基準時間を入れる */	/* Del Ver2.0 */
        double In_Ti_d;         /* 時刻付計算用の変数。入力Tiを入れる*/
        uint32_t ETI;           /* ETI          */								/* Chg Ver2.0 */
//        int endtbl_outflg;      /* 最後のレコードを展開していて、       */	/* Del Ver2.0 */
                                /* TIが範囲外であることを判定する       */

        int first;              /* 有効範囲の先頭位置ポインタ           */	/* Chg Ver2.0 */
        int last;               /* 有効範囲の最後位置ポインタ           */
        double In_SATsec_d;     /* 内部関数用の変数。パラメータ衛星時刻を入れる */
        double In_SATsec_w;		/* 探索用衛星時刻 */					/* Add Ver2.0 */
		int rtn;				/* リターンコード */					/* Add Ver2.0 */
		double subsec;			/* 指定UTCと取得UTCとの差分時間(sec) */	/* Add Ver2.0 */
		uint32_t day;			/* 範囲指定日数 				*/		/* Add Ver2.0 */
		double daysec;			/* 範囲指定日数 x １日の秒数 	*/		/* Add Ver2.0 */
		uint32_t In_day;		/* 入力した範囲指定日数 		*/		/* Add Ver2.0 */
		double In_daysec;		/* 入力した範囲指定日数 x １日の秒数 */	/* Add Ver2.0 */

		uint32_t day2;			/* 範囲指定日数 				*/		/* Add Ver3.0.0 */
		double daysec2;			/* 範囲指定日数 x １日の秒数 	*/		/* Add Ver3.0.0 */
		uint32_t In_day2;		/* 入力した範囲指定日数 		*/		/* Add Ver3.0.0 */
		double In_daysec2;		/* 入力した範囲指定日数 x １日の秒数 */	/* Add Ver3.0.0 */

		int	search_end;			/* 探索終了フラグ */					/* Add Ver2.0 */

} TiTm_work;

/***********************************************************************
   衛星時刻校正表 ファイルフォーマット

          1         2         3         4         5         6         7         8         9
0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789
9999999999 9.9999999999999999E+00 YYYYMMDDhhmmssMMMUUU 9.9999999999999999E+00 N YYMMDD9999 0xFFFFFFF
EtiExt     EtiBase                UTC                  Rate[usec/tick]        Q PassNo     TI(RAW)

0         1         2         3         4         5         6         7         8         9
0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789
             YYYYMMDDhhmmssMMMUUU ZZZZZZZZ 9999Z S YYMMDD9999.anp YYYYMMDDhhmmss  9999999999999.999
             ERT[UTC]             Antenna    Bit @ ANPFileName    ANPTimeTag      DownLinkRange[km]

Q:クオリティフラグ(S:正常,E:計算エラー,R:リセット後)
Bit:BitRate[bps]
@:S/Xフラグ ( 受信帯域  S:S帯, X:X帯 )
CR: 改行コード( 0x0a )

************************************************************************/

/***********************************************************************
   SDTPフォーマット

SDTPヘッダ　情報フィールド　データフィールド　情報フィールド　データフィールド．．．

情報フィールド
0123456789012
X        9999
X:レコード識別(1:先頭データ,2:中間データ,4:最終データ)
9999:データフィールドデータ長（BIN)

データフィールド
先頭データ(56バイト)
0 1234567890 1 23456789 0123456789
X YYMMDD9999 9 99999999 CCCCC...
パス先頭識別
パス番号(BCD)
衛星番号(BIN)
コメント

最終データ(20バイト)
0 1234567890 1 23456789
X YYMMDD9999 9
パス終了識別
パス番号(BCD)
衛星番号(BIN)

************************************************************************
テレメトリデータ
付加情報＋受信データ

付加情報
0 1 23456789012345678901 2 3 4 5 6 7 890123456789
9 9 YYYY0DDDHHMMSSMMMmmm 9 9 X X X X YYMMDD9999
装置番号
衛星番号
受信時刻(BCD)
受信アンテナＩＤ
受信バンド帯
復調機ステータス１
   B5 1:リードソロモン復号有り
   B6 1:リードソロモンエラー有り
   B7 1:リードソロモンエラー訂正
復調機ステータス２
ロックステータス
ビットレート
  0x00 :  64BPS
  0X01 : 128BPS
    ・
    ・
    ・
パス番号(BCD)
************************************************************************
受信データ（テレメトリデータ）
トランスファフレーム(1024バイト)
 SYNC(4バイト)  0x1acffc1d
 CVCDU(1020バイト)
  VCDU Header(6バイト)
  VCDU Data Unit Zone(882バイト)
   M_PDU Header(2バイト)
   M_PDU Packet Zone(880バイト)
  CLCW(4バイト)
  Read-Solomon(128バイト)

パケット
 Primary Header(6バイト)
 Secondary Header(4バイト)
 User Data(高速観測データ以外：426バイト固定)
          (高速観測データ    ：1～2034バイト)

************************************************************************
VCDU Header(6バイト(48bits))
--------------------------------
Version No 			(2bits)
VCDU Identifier
	Spacecraft ID 	(8bits)
	VCID			(6bits)
VCDU Counter		(24bits)
Signaling Field
	Replay Flag		(1bit)
	Spare			(7bits)
--------------------------------
--------------------------------

VCID(6bits)
00 0000 (0x00):  DHU_H/W
00 0001 (0x01):  S-Band HK-Real
00 0010 (0x02):  X-Band HK-Real
00 1001 (0x09):  FIS Real(X-Band Only)
00 1010 (0x0A):  IRC Real(X-Band Only)
10 0001 (0x21):  X-Band REP DR-PT-1
10 0010 (0x22):  X-Band REP DR-PT-2
10 0011 (0x23):  S-Band REP DR-PT-1
10 0100 (0x24):  S-Band REP DR-PT-2
11 1111 (0x3F):  Fill


************************************************************************
パケットPrimary Header(6バイト)

--------------------------------
Version 			(3bits)  ("000")
Type				(1bit)   ("0")
Sec.Header Flag		(1bit)
APID				(11bits)
Sequence Flag		(2bits)  (SOLAR-B は "11" 固定)
Sequence Count		(14bits) (SOLAR-B は "00000000000000" 固定)
Packet Length		(16bits)
--------------------------------
--------------------------------

APID(11bits)
 Common Use		(2bits)
 機器ID			(4bits)
 Data Type ID	(5bits)

 Packet Name	:	Hex Code
 DHU_DMP 		:	0220
 HK_1	 		:	0428  ← HK-1パケット(時刻テレメトリ)
 HK_2	 		:	0430
 DHU	 		:	0438
 AOCU_DMP 		:	0240
 AOCU	 		:	0448
 AOCS_CHK 		:	0450
 INS	 		:	0460
 DR		 		:	04A0
 IRC_HK	 		:	04C0
 IRC_OBS 		:	00C0
 IRC_DMP 		:	02C0
 FIS_HK 		:	04E0
 FIS_OBS 		:	00E0
 FIS_DMP 		:	02E0


************************************************************************
パケットSecondary Header(4バイト)
Time Indicator (32bits) (4バイト) : 2^26(約777日) ～ 2^-5(31.25ms)

************************************************************************


************************************************************************/

int TiTm_Init_Sat( TiTm_tbl *titm, double Sat_Time, uint32_t day, uint32_t day2 );		/* Chg Ver2.0 */
int TiTm_Init_Eti( TiTm_tbl *titm, uint32_t ETI, uint32_t TI );			/* Chg Ver2.0 */
int TiTm_Init_Eti2( TiTm_tbl *titm, uint32_t ETI, uint64_t TI );		/* Add Ver3.3.0 */
double find_valid_rate(int read_cnt, TiTm_tbl *titm);					/* Add Ver3.0.0 */
int outputMessage( char *msg );								/* Add Ver3.0.0 */

/*
 * ver3.0.0 エラーメッセージ
 */
#define EMGS_MSG_LENGTH 256
#define EMSG_FILEREAD_ERR_FMT0 "TIMECAL:ERR:(%4.4d/%2.2d/%2.2d %2.2d:%2.2d:%2.2d), "
#define EMSG_FILEREAD_ERR_FMT1 "FileName=[%s], LineNum=[%d], ColNum=[%d], Reason=[%s]\n"
#define EMSG_FILEREAD_ERR_FMT2 "FileName=[%s], LineNum=[%d], ColNum=[-], Reason=[%s]\n"
#define EMSG_FILEREAD_ERR_FMT3 "FileName=[%s], LineNum=[-], ColNum=[-], Reason=[%s]\n"
#define EMSG_FILEREAD_ERR_REASON1 "No Item."
#define EMSG_FILEREAD_ERR_REASON2 "Content is invalid."
#define EMSG_FILEREAD_ERR_REASON3 "Length is not correct."
#define EMSG_FILEREAD_ERR_REASON4 "No valid record."
#define EMSG_FILEREAD_ERR_REASON5 "Length of the last line is not correct."
#define EMSG_FILEREAD_ERR_REASON6 "Record count is invalid."	/* Add Ver3.1.1 */
#define EMSG_FILEREAD_ERR_REASON7 "Could not allocate memory."	/* Add Ver3.1.1 */

#endif	/*SATCA_COM_HEADER*/

